/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.mock;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.coodex.mock.MockException;
import org.coodex.mock.MockerProvider;

public final class Mocker {
    private static final String DEFAULT_PROVIDER_CLASS = Mocker.class.getPackage().getName() + ".CoodexMockerProvider";
    private static boolean instanceLoaded = false;
    private static MockerProvider mockerProviderInstance = null;
    private static Throwable th = null;

    private Mocker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static MockerProvider getMockerProvider() {
        if (!instanceLoaded) {
            Class<Mocker> clazz = Mocker.class;
            // MONITORENTER : org.coodex.mock.Mocker.class
            if (!instanceLoaded) {
                try {
                    Iterator<MockerProvider> serviceLoader = ServiceLoader.load(MockerProvider.class).iterator();
                    mockerProviderInstance = serviceLoader.hasNext() ? serviceLoader.next() : (MockerProvider)Class.forName(DEFAULT_PROVIDER_CLASS).newInstance();
                }
                catch (Throwable throwable) {
                    th = throwable;
                }
                finally {
                    instanceLoaded = true;
                }
            }
            // MONITOREXIT : clazz
        }
        if (mockerProviderInstance != null) return mockerProviderInstance;
        if (th != null) throw new MockException("none provider found. ", th);
        throw new MockException("none provider found.");
    }

    public static <T> T mock(Class<T> type, Annotation ... annotations) {
        return Mocker.getMockerProvider().mock(type, annotations);
    }

    public static Object mock(Type type, Type context, Annotation ... annotations) {
        return Mocker.getMockerProvider().mock(type, context, annotations);
    }

    public static Object mockMethod(Method method) {
        return Mocker.mockMethod(method, method.getDeclaringClass());
    }

    public static Object mockMethod(Method method, Type instanceType) {
        return Mocker.mock(method.getGenericReturnType(), instanceType, Mocker.merge(method.getAnnotations(), Mocker.getTypeAnnotations(instanceType)));
    }

    public static Annotation[] getTypeAnnotations(Type instanceType) {
        Class contextClass = null;
        if (instanceType instanceof Class) {
            contextClass = (Class)instanceType;
        } else if (instanceType instanceof ParameterizedType) {
            contextClass = (Class)((ParameterizedType)instanceType).getRawType();
        }
        return contextClass == null ? null : contextClass.getAnnotations();
    }

    private static Annotation[] merge(Annotation[] ... annotations) {
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        if (annotations != null) {
            for (Annotation[] array : annotations) {
                if (array == null || array.length <= 0) continue;
                list.addAll(Arrays.asList(array));
            }
        }
        return list.toArray(new Annotation[0]);
    }

    public static Object mockParameter(Method method, int index) {
        return Mocker.mockParameter(method, index, method.getDeclaringClass());
    }

    public static Object mockParameter(Method method, int index, Type instanceType) {
        return Mocker.mock(method.getGenericParameterTypes()[index], instanceType, Mocker.merge(method.getParameterAnnotations()[index], method.getAnnotations(), Mocker.getTypeAnnotations(instanceType)));
    }
}

