/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.mock.ext;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.coodex.mock.Mock;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
@Mock
public @interface IpAddress {
    public Type type() default Type.IPV4;

    public static enum Type {
        IPV4(4),
        MAC(6),
        TPV6(16);

        private int size;

        private Type(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public String ipToString(int[] ip) {
            if (ip == null) {
                throw new NullPointerException("IP null.");
            }
            if (ip.length != this.size) {
                throw new IllegalArgumentException("size mismatch.");
            }
            char s = ip.length >= 6 ? (char)':' : '.';
            boolean v6 = ip.length == 16;
            String format = ip.length >= 6 ? "%02X" : "%d";
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < ip.length; ++i) {
                if (!(i <= 0 || v6 && i % 2 != 0)) {
                    builder.append(s);
                }
                builder.append(String.format(format, ip[i]));
            }
            return builder.toString();
        }
    }
}

