/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.coodex.util.RenderService;
import org.coodex.util.SingletonMap;

public class FreeMarkerRenderService
implements RenderService {
    public static final Pattern PATTERN = Pattern.compile("\\$\\{o[0-9]+([.?!][^]]+)?}");
    private static final Configuration FREEMARKER = new Configuration(Configuration.getVersion());
    private static final StringTemplateLoader TEMPLATE_LOADER = new StringTemplateLoader();
    private static final SingletonMap<String, Template> TEMPLATE_SINGLETON_MAP = SingletonMap.builder().function(FreeMarkerRenderService::getTemplate).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Template getTemplate(String template) {
        StringTemplateLoader stringTemplateLoader = TEMPLATE_LOADER;
        synchronized (stringTemplateLoader) {
            TEMPLATE_LOADER.putTemplate(template, template);
        }
        return FREEMARKER.getTemplate(template);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String formatMsg(String template, Map<String, Object> values) {
        if (template == null) {
            return null;
        }
        Template t = (Template)TEMPLATE_SINGLETON_MAP.get((Object)template);
        try (StringWriter writer = new StringWriter();){
            t.process(values, (Writer)writer);
            String string = ((Object)writer).toString();
            return string;
        }
    }

    private static Map<String, Object> toMap(Object[] objects) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (int i = 1; i <= objects.length; ++i) {
            values.put("o" + i, objects[i - 1]);
        }
        return values;
    }

    public String render(String template, Object ... objects) {
        if (objects == null || objects.length == 0) {
            return template;
        }
        return FreeMarkerRenderService.formatMsg(template, FreeMarkerRenderService.toMap(this.transfer(objects)));
    }

    public boolean accept(String param) {
        return param != null && PATTERN.matcher(param).find();
    }

    static {
        FREEMARKER.setTemplateLoader((TemplateLoader)TEMPLATE_LOADER);
    }
}

