/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.security.impl;

import java.security.PrivateKey;
import java.security.PublicKey;
import org.coodex.security.SecretContext;

public class RSASecretContext
implements SecretContext {
    private long keyCreated;
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private int keySize = 1024;

    public RSASecretContext(int keySize) {
        this.keySize = keySize;
    }

    public RSASecretContext() {
        this(1024);
    }

    @Override
    public synchronized PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public synchronized void reset() {
        this.keyCreated = System.currentTimeMillis();
    }

    @Override
    public long keyAge() {
        return System.currentTimeMillis() - this.keyCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decrypt(byte[] cipherContent) {
        RSASecretContext rSASecretContext = this;
        synchronized (rSASecretContext) {
            PrivateKey key = this.privateKey;
        }
        return new byte[0];
    }

    @Override
    public byte[] encrypt(byte[] content) {
        PublicKey key = this.getPublicKey();
        return new byte[0];
    }
}

