/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.servlet.cors;

import java.util.StringTokenizer;
import org.coodex.servlet.cors.CORSSetting;
import org.coodex.servlet.cors.HeaderSetter;

public class CORSSetter {
    public static void set(CORSSetting setting, HeaderSetter setter, String origin) {
        Boolean allowCredentials = setting.allowCredentials();
        Long maxAge = setting.maxAge();
        String allowHeaders = setting.allowHeaders();
        String allowMethod = setting.allowMethod();
        String allowOrigin = setting.allowOrigin();
        String exposeHeaders = setting.exposeHeaders();
        if (allowCredentials != null) {
            setter.set("Access-Control-Allow-Credentials", String.valueOf(allowCredentials));
        }
        if (maxAge != null) {
            setter.set("Access-Control-Max-Age", String.valueOf(maxAge));
        }
        if (allowHeaders != null) {
            setter.set("Access-Control-Allow-Headers", allowHeaders);
        }
        if (allowOrigin != null) {
            StringTokenizer st = new StringTokenizer(allowOrigin, ", ", false);
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (!s.equals("*") && !s.equalsIgnoreCase(origin)) continue;
                setter.set("Access-Control-Allow-Origin", origin);
                break;
            }
        }
        if (allowMethod != null) {
            setter.set("Access-Control-Allow-Methods", allowMethod);
        }
        if (exposeHeaders != null) {
            setter.set("Access-Control-Expose-Headers", exposeHeaders);
        }
    }
}

