/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.servlet.cors.impl;

import org.coodex.servlet.cors.CORSSetting;
import org.coodex.util.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CORSSettingInProfile
implements CORSSetting {
    private static final Logger log = LoggerFactory.getLogger(CORSSettingInProfile.class);
    private final Profile profile;

    public CORSSettingInProfile() {
        this("cors_settings.properties");
    }

    public CORSSettingInProfile(String profileName) {
        this.profile = Profile.get((String)profileName);
    }

    @Override
    public String allowOrigin() {
        return this.profile.getString("allowOrigin");
    }

    @Override
    public String exposeHeaders() {
        return this.profile.getString("exposeHeaders");
    }

    @Override
    public String allowMethod() {
        return this.profile.getString("allowMethod");
    }

    @Override
    public String allowHeaders() {
        return this.profile.getString("allowHeaders");
    }

    @Override
    public Long maxAge() {
        String maxAge = this.profile.getString("maxAge");
        Long lMaxAge = null;
        try {
            if (maxAge != null) {
                lMaxAge = Long.valueOf(maxAge);
            }
        }
        catch (Throwable th) {
            log.info("cannot load maxAge, type need: long. {} ", (Object)th.getLocalizedMessage(), (Object)th);
        }
        return lMaxAge;
    }

    @Override
    public Boolean allowCredentials() {
        String allowCredentials = this.profile.getString("allowCredentials");
        Boolean blAC = null;
        try {
            if (allowCredentials != null) {
                blAC = Boolean.valueOf(allowCredentials);
            }
        }
        catch (Throwable th) {
            log.info("cannot load allowCredentials, type need: boolean. {} ", (Object)th.getLocalizedMessage(), (Object)th);
        }
        return blAC;
    }
}

