/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.servlet.cors;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.coodex.servlet.cors.CORSSetter;
import org.coodex.servlet.cors.CORSSetting;
import org.coodex.servlet.cors.impl.CORSSettingInConfiguration;

public class CorsFilter
implements Filter {
    private final CORSSetting corsSetting;

    public CorsFilter() {
        this(new CORSSettingInConfiguration());
    }

    public CorsFilter(CORSSetting corsSetting) {
        this.corsSetting = corsSetting;
    }

    public void init(FilterConfig filterConfig) {
    }

    protected CORSSetting getCorsSetting() {
        return this.corsSetting;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        CORSSetter.set(this.getCorsSetting(), (arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1), request.getHeader("Origin"));
        if ("OPTIONS".equalsIgnoreCase(request.getMethod())) {
            response.setStatus(200);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
    }
}

