/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public final class ExecutorWrapper {
    private static final Set<ExecutorService> executors = new HashSet<ExecutorService>();

    public static final <T extends ExecutorService> T wrap(T executorService) {
        executors.add(executorService);
        return executorService;
    }

    public static void shutdown() {
        for (ExecutorService service : executors) {
            if (service == null || service.isShutdown() || service.isTerminated()) continue;
            service.shutdown();
        }
    }

    public static List<Runnable> shutdownNow() {
        ArrayList<Runnable> list = new ArrayList<Runnable>();
        for (ExecutorService service : executors) {
            if (service == null || service.isTerminated()) continue;
            list.addAll(service.shutdownNow());
        }
        return list;
    }
}

