/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.pojomocker;

import java.util.NoSuchElementException;
import java.util.Stack;
import org.coodex.pojomocker.MockContext;

public class MockContextHelper {
    private static final ThreadLocal<Stack<MockContext>> stackThreadLocal = new ThreadLocal();
    private static final ThreadLocal<Stack<StackTraceElement>> invokerThreadLocal = new ThreadLocal();

    private static Stack<MockContext> getStack() {
        Stack<MockContext> stack = stackThreadLocal.get();
        if (stack == null) {
            stack = new Stack();
            stackThreadLocal.set(stack);
        }
        return stack;
    }

    private static StackTraceElement getInvoker() {
        Throwable th = new Throwable();
        return th.getStackTrace()[3];
    }

    private static Stack<StackTraceElement> getInvokerStack() {
        Stack<StackTraceElement> stack = invokerThreadLocal.get();
        if (stack == null) {
            stack = new Stack();
            invokerThreadLocal.set(stack);
        }
        return stack;
    }

    private static void accessCheck(StackTraceElement ste) throws IllegalAccessException {
    }

    private static final void pushInvoker() throws IllegalAccessException {
        StackTraceElement ste = MockContextHelper.getInvoker();
        MockContextHelper.getInvokerStack().push(ste);
        MockContextHelper.accessCheck(ste);
    }

    private static final void popInvoker() throws IllegalAccessException {
        StackTraceElement ste = MockContextHelper.getInvoker();
        MockContextHelper.accessCheck(ste);
        try {
            StackTraceElement steClosest = MockContextHelper.getInvokerStack().pop();
            if (!ste.getClassName().equals(steClosest.getClassName()) || !ste.getMethodName().equals(steClosest.getMethodName())) {
                throw new IllegalAccessException("\nenter() invoked by: " + steClosest.toString() + "\nleave() invoked by: " + ste.toString());
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalAccessException("enter() NOT called.");
        }
    }

    public static MockContext currentContext() {
        Stack<MockContext> stack = MockContextHelper.getStack();
        if (stack.size() == 0) {
            return null;
        }
        return (MockContext)stack.lastElement();
    }

    public static final MockContext enter() throws IllegalAccessException {
        MockContextHelper.pushInvoker();
        MockContext context = new MockContext(MockContextHelper.currentContext());
        MockContextHelper.getStack().push(context);
        return context;
    }

    public static final void leave() throws IllegalAccessException {
        MockContextHelper.popInvoker();
        Stack<MockContext> stack = MockContextHelper.getStack();
        if (stack.size() != 0) {
            stack.pop();
        }
    }
}

