/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.pojomocker;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import org.coodex.pojomocker.AbstractTypeBasedMocker;
import org.coodex.pojomocker.ClassTypeMocker;
import org.coodex.pojomocker.GenericArrayTypeMocker;
import org.coodex.pojomocker.MockContext;
import org.coodex.pojomocker.MockContextHelper;
import org.coodex.pojomocker.POJOMockInfo;
import org.coodex.pojomocker.POJOMocker;
import org.coodex.pojomocker.POJOMockerFactory;
import org.coodex.pojomocker.ParameterizedTypeMocker;
import org.coodex.pojomocker.TypeVariableMocker;
import org.coodex.pojomocker.UnableMockException;
import org.coodex.pojomocker.UnsupportedTypeException;

class POJOMockerImpl {
    private static final AbstractTypeBasedMocker<? extends Type> typeVariableMocker = new TypeVariableMocker();
    private static final AbstractTypeBasedMocker<? extends Type> parameterizedTypeMocker = new ParameterizedTypeMocker();
    private static final AbstractTypeBasedMocker<? extends Type> genericArrayMocker = new GenericArrayTypeMocker();
    private static final AbstractTypeBasedMocker<? extends Type> classMocker = new ClassTypeMocker();
    private final Map<Class<? extends POJOMockerFactory>, POJOMockerFactory> factorys = new HashMap<Class<? extends POJOMockerFactory>, POJOMockerFactory>();

    POJOMockerImpl() {
    }

    private AbstractTypeBasedMocker<? extends Type> getTypeMocker(Type type) throws UnsupportedTypeException {
        if (type instanceof Class) {
            return classMocker;
        }
        if (type instanceof TypeVariable) {
            return typeVariableMocker;
        }
        if (type instanceof ParameterizedType) {
            return parameterizedTypeMocker;
        }
        if (type instanceof GenericArrayType) {
            return genericArrayMocker;
        }
        throw new UnsupportedTypeException(type);
    }

    synchronized POJOMockerFactory getFactory(Class<? extends POJOMockerFactory> clz) {
        POJOMockerFactory factory = this.factorys.get(clz);
        if (factory == null) {
            try {
                factory = clz.newInstance();
                this.factorys.put(clz, factory);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object mock(Type type, POJOMockInfo pmi, Type contextClass) throws UnableMockException, UnsupportedTypeException, IllegalAccessException {
        if (pmi == null) {
            pmi = new POJOMockInfo();
        }
        MockContextHelper.enter();
        try {
            MockContext context = MockContextHelper.currentContext();
            if (contextClass != null) {
                context.addContextType(contextClass);
            }
            context.setMockInfo(pmi);
            Object object = this.$mock(type, context);
            return object;
        }
        finally {
            MockContextHelper.leave();
        }
    }

    Object $mock(Type type, MockContext context) throws UnsupportedTypeException, IllegalAccessException, IllegalArgumentException, UnableMockException {
        POJOMocker.assertNull(type, "type is Null.");
        POJOMocker.assertNull(context, "mockContext is Null.");
        return this.getTypeMocker(type).mock(type, context);
    }
}

