/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.pojomocker;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Map;
import org.coodex.pojomocker.AbstractTypeBasedMocker;
import org.coodex.pojomocker.MockContext;
import org.coodex.pojomocker.MockContextHelper;
import org.coodex.pojomocker.POJOMockInfo;
import org.coodex.pojomocker.UnableMockException;
import org.coodex.pojomocker.UnsupportedTypeException;
import org.coodex.util.Common;
import org.coodex.util.TypeHelper;

public class ParameterizedTypeMocker
extends AbstractTypeBasedMocker<ParameterizedType> {
    @Override
    protected Class<?> getTypeClass() {
        return ParameterizedType.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object $mock(ParameterizedType type, MockContext context) throws UnsupportedTypeException, IllegalAccessException, UnableMockException {
        Class rawType = (Class)type.getRawType();
        MockContextHelper.enter();
        try {
            context = MockContextHelper.currentContext().addContextType(type);
            Type[] types = type.getActualTypeArguments();
            Class declared = (Class)type.getRawType();
            for (int i = 0; i < types.length; ++i) {
                if (!(types[i] instanceof TypeVariable)) continue;
                context.addReplace(declared, i, types[i]);
            }
            Object result = context.getFactory().getClassInstanceMocker(rawType).mockInstance(rawType, context, types);
            this.mockCollection(type, context, rawType, result);
            this.mockMap(type, context, rawType, result);
            Object t = result;
            return t;
        }
        finally {
            MockContextHelper.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mockMap(ParameterizedType type, MockContext context, Class<?> rawType, Object result) throws IllegalAccessException, UnsupportedTypeException, UnableMockException {
        Type keyType = this.findMapType(rawType, type, 0);
        Type elementType = this.findMapType(rawType, type, 1);
        if (elementType != null && keyType != null) {
            Map map = (Map)result;
            POJOMockInfo pmi = context.getMockInfo();
            int randomSize = Common.random(Math.max(1, pmi.getMin()), pmi.getMax());
            for (int i = 0; i < randomSize; ++i) {
                MockContextHelper.enter();
                try {
                    map.put(this.mockByType(context, keyType), this.mockByType(context, elementType));
                    continue;
                }
                finally {
                    MockContextHelper.leave();
                }
            }
        }
    }

    private Object mockByType(MockContext context, Type elementType) throws UnsupportedTypeException, IllegalAccessException, UnableMockException {
        Object element;
        if (elementType instanceof TypeVariable) {
            Type t = context.findTypeVariableActurlType((TypeVariable)elementType);
            element = ParameterizedTypeMocker.mockByType(t);
        } else {
            element = ParameterizedTypeMocker.mockByType(elementType);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mockCollection(ParameterizedType type, MockContext context, Class<?> rawType, Object result) throws IllegalAccessException, UnsupportedTypeException, UnableMockException {
        Type elementType = this.findElementType(rawType, type);
        if (elementType != null) {
            Collection collection = (Collection)result;
            POJOMockInfo pmi = context.getMockInfo();
            int randomSize = Common.random(Math.max(1, pmi.getMin()), pmi.getMax());
            for (int i = 0; i < randomSize; ++i) {
                MockContextHelper.enter();
                try {
                    collection.add(this.mockByType(context, elementType));
                    continue;
                }
                finally {
                    MockContextHelper.leave();
                }
            }
        }
    }

    private Type findElementType(Class<?> collectionType, ParameterizedType type) {
        if (Collection.class.isAssignableFrom(collectionType)) {
            TypeVariable<Class<?>> tv = Collection.class.getTypeParameters()[0];
            Type t = TypeHelper.searchActualType(tv, type);
            if (t == null || t instanceof TypeVariable) {
                t = type.getActualTypeArguments()[0];
            }
            return t;
        }
        return null;
    }

    private Type findMapType(Class<?> collectionType, ParameterizedType type, int index) {
        if (Map.class.isAssignableFrom(collectionType)) {
            TypeVariable<Class<?>> tv = Map.class.getTypeParameters()[index];
            Type t = TypeHelper.searchActualType(tv, type);
            if (t == null || t instanceof TypeVariable) {
                t = type.getActualTypeArguments()[0];
            }
            return t;
        }
        return null;
    }
}

