/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.coodex.util.Common;

public class DigestHelper {
    private static final String DEFAULT_ENCODING = "UTF-8";

    private static String digest(byte[] buf, String al) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(al);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return Common.byte2hex(md.digest(buf));
    }

    public static String sha1(byte[] content) {
        return DigestHelper.digest(content, "sha1");
    }

    public static byte[] hmac(byte[] content, byte[] key, String algorithm) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec secretKey = new SecretKeySpec(key, algorithm);
        Mac mac = Mac.getInstance(algorithm);
        mac.init(secretKey);
        return mac.doFinal(content);
    }

    public static byte[] hmac(byte[] content, byte[] key) throws NoSuchAlgorithmException, InvalidKeyException {
        return DigestHelper.hmac(content, key, "HmacSHA1");
    }

    public static String hmac(String content, String key, String algorithm, String encoding) throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException {
        if (content == null) {
            content = "";
        }
        if (key == null) {
            throw new NullPointerException("hmac key is NULL.");
        }
        return Common.byte2hex(DigestHelper.hmac(content.getBytes(encoding), key.getBytes(encoding), algorithm));
    }

    public static String hmac(String content, String key, String algorithm) throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException {
        return DigestHelper.hmac(content, key, algorithm, DEFAULT_ENCODING);
    }

    public static String hmac(String content, String key) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException {
        return DigestHelper.hmac(content, key, "HmacSHA1");
    }
}

