/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.coodex.util.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SPIFacade<T> {
    private static final Logger log = LoggerFactory.getLogger(SPIFacade.class);
    protected Map<String, T> instances = null;

    public SPIFacade() {
        this.loadInstances();
    }

    protected Class<T> getInterfaceClass() {
        return (Class)TypeHelper.findActualClassFrom(SPIFacade.class.getTypeParameters()[0], this.getClass());
    }

    protected T getDefaultProvider() {
        throw new RuntimeException("no provider found for: " + this.getInterfaceClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadInstances() {
        if (this.instances == null) {
            SPIFacade sPIFacade = this;
            synchronized (sPIFacade) {
                if (this.instances == null) {
                    this.instances = new HashMap<String, T>();
                    ServiceLoader<T> loader = ServiceLoader.load(this.getInterfaceClass());
                    for (T service : loader) {
                        if (service == null) continue;
                        this.instances.put(service.getClass().getCanonicalName(), service);
                    }
                    if (this.instances.size() == 0) {
                        log.debug("no ServiceProvider found for [{}]", (Object)this.getInterfaceClass().getCanonicalName());
                    }
                }
            }
        }
    }

    public Collection<T> getAllInstances() {
        return this.instances.values();
    }

    public T getInstance(Class<? extends T> providerClass) {
        return this.getInstance(providerClass.getCanonicalName());
    }

    public T getInstance(String className) {
        T instance = this.instances.get(className);
        return instance == null ? this.getDefaultProvider() : instance;
    }

    protected T conflict() {
        StringBuffer buffer = new StringBuffer(this.getInterfaceClass().getName());
        buffer.append(" has ").append(this.instances.size()).append(" services:[");
        for (T service : this.instances.values()) {
            buffer.append("\n\t").append(service.getClass().getName());
        }
        buffer.append("]");
        throw new RuntimeException(buffer.toString());
    }

    public T getInstance() {
        if (this.instances.size() == 0) {
            return this.getDefaultProvider();
        }
        if (this.instances.size() == 1) {
            return (T)this.instances.values().toArray()[0];
        }
        return this.conflict();
    }
}

