/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.coodex.util.TypeHelper$$;

public class TypeHelper {
    private static final ExceptClassFilter javaLangExceptFilter = new JavaLangExceptFilter();

    public static Type findActualClassFrom(TypeVariable type, Type instanceClass) {
        return TypeHelper.findActualClassFromInstanceClass(type, instanceClass);
    }

    public static Type findActualClassFromInstanceClass(TypeVariable<Class<?>> type, Type instancedClass) {
        return TypeHelper.findActualClassFromInstanceClass(type, instancedClass, null);
    }

    public static Type findActualClassFromInstanceClass(TypeVariable<Class<?>> type, Type instancedClass, ExceptClassFilter filter) {
        Type t = type;
        while ((t = TypeHelper.searchActualType(t, instancedClass, filter)) instanceof TypeVariable) {
        }
        return t;
    }

    private static Type searchActualTypeInParameterizedType(TypeVariable<Class<?>> type, ParameterizedType pt, ExceptClassFilter filter) {
        Type result = null;
        Class<?> declaringClass = type.getGenericDeclaration();
        if (pt.getRawType() == declaringClass) {
            TypeVariable<Class<?>>[] t = declaringClass.getTypeParameters();
            for (int i = 0; i < t.length; ++i) {
                if (type != t[i]) continue;
                result = pt.getActualTypeArguments()[i];
                break;
            }
        } else {
            Type $;
            Type[] typeArray = pt.getActualTypeArguments();
            int n = typeArray.length;
            for (int i = 0; i < n && (result = TypeHelper.searchActualType(type, $ = typeArray[i], filter)) == null; ++i) {
            }
        }
        return result;
    }

    public static Type searchActualType(TypeVariable<Class<?>> type, Type instancedInfo) {
        return TypeHelper.searchActualType(type, instancedInfo, javaLangExceptFilter);
    }

    public static Type searchActualType(TypeVariable<Class<?>> type, Type instancedInfo, ExceptClassFilter filter) {
        if (type == null || instancedInfo == null) {
            return null;
        }
        Type result = null;
        if (instancedInfo instanceof ParameterizedType) {
            result = TypeHelper.searchActualTypeInParameterizedType(type, (ParameterizedType)instancedInfo, filter);
        } else if (instancedInfo instanceof Class) {
            result = TypeHelper.searchActualTypeInClass(type, (Class)instancedInfo, filter);
        } else if (instancedInfo instanceof GenericArrayType) {
            result = TypeHelper.searchActualType(type, ((GenericArrayType)instancedInfo).getGenericComponentType(), filter);
        }
        return result;
    }

    private static Type searchActualTypeInClass(TypeVariable<Class<?>> type, Class<?> instancedInfo, ExceptClassFilter filter) {
        Type $;
        int n;
        int n2;
        Type[] typeArray;
        Type[] interfaces;
        if (filter != null && filter.except(instancedInfo) || javaLangExceptFilter.except(instancedInfo)) {
            return null;
        }
        Type result = TypeHelper.searchActualType(type, instancedInfo.getGenericSuperclass(), filter);
        if (result == null) {
            typeArray = interfaces = instancedInfo.getGenericInterfaces();
            n2 = typeArray.length;
            for (n = 0; n < n2 && (result = TypeHelper.searchActualType(type, $ = typeArray[n], filter)) == null; ++n) {
            }
        }
        if (result == null) {
            result = TypeHelper.searchActualType(type, instancedInfo.getSuperclass(), filter);
        }
        if (result == null) {
            typeArray = interfaces = instancedInfo.getInterfaces();
            n2 = typeArray.length;
            for (n = 0; n < n2 && (result = TypeHelper.searchActualType(type, $ = typeArray[n], filter)) == null; ++n) {
            }
        }
        return result;
    }

    public static Type toTypeReference(Type type, Class<?> contextClass) {
        if (type instanceof ParameterizedType) {
            return new $$ParameterizedType((ParameterizedType)type, contextClass);
        }
        if (type instanceof TypeVariable) {
            return TypeHelper.findActualClassFrom((TypeVariable)type, contextClass);
        }
        if (type instanceof GenericArrayType) {
            return new $$GenericArrayType((GenericArrayType)type, contextClass, null);
        }
        return type;
    }

    private static class JavaLangExceptFilter
    implements ExceptClassFilter {
        private JavaLangExceptFilter() {
        }

        @Override
        public boolean except(Class<?> c) {
            return c.getPackage().getName().startsWith("java.lang");
        }
    }

    public static interface ExceptClassFilter {
        public boolean except(Class<?> var1);
    }
}

