/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.coodex.concurrent.ExecutorWrapper;
import org.coodex.concurrent.components.PriorityRunnable;

public class ExecutorsHelper {
    private static PriorityRunnable getPriorityRunnable(Runnable runnable) {
        return runnable instanceof PriorityRunnable ? (PriorityRunnable)runnable : new PriorityRunnable(5, runnable);
    }

    public static ExecutorService newPriorityThreadPool(int coreSize, int maxSize) {
        int finalMaxSize;
        int finalCoreSize = Math.max(coreSize, 1);
        int n = finalMaxSize = maxSize >= coreSize ? maxSize : Integer.MAX_VALUE;
        if (finalMaxSize == Integer.MAX_VALUE) {
            finalMaxSize = 0x7FFFFFFE;
        }
        ConcretePriorityBlockingQueue priorityBlockingQueue = new ConcretePriorityBlockingQueue();
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(finalCoreSize, finalMaxSize + 1, 60L, TimeUnit.SECONDS, priorityBlockingQueue);
        priorityBlockingQueue.setThreadPoolExecutor(threadPool);
        return ExecutorWrapper.wrap(threadPool);
    }

    public static ExecutorService newFixedThreadPool(int nThreads) {
        return ExecutorWrapper.wrap(Executors.newFixedThreadPool(nThreads));
    }

    public static ExecutorService newFixedThreadPool(int nThreads, ThreadFactory threadFactory) {
        return ExecutorWrapper.wrap(Executors.newFixedThreadPool(nThreads, threadFactory));
    }

    public static ExecutorService newSingleThreadExecutor() {
        return ExecutorWrapper.wrap(Executors.newSingleThreadExecutor());
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory) {
        return ExecutorWrapper.wrap(Executors.newSingleThreadExecutor(threadFactory));
    }

    public static ExecutorService newCachedThreadPool() {
        return ExecutorWrapper.wrap(Executors.newCachedThreadPool());
    }

    public static ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return ExecutorWrapper.wrap(Executors.newCachedThreadPool(threadFactory));
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor() {
        return ExecutorWrapper.wrap(Executors.newSingleThreadScheduledExecutor());
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory) {
        return ExecutorWrapper.wrap(Executors.newSingleThreadScheduledExecutor(threadFactory));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize) {
        return ExecutorWrapper.wrap(Executors.newScheduledThreadPool(corePoolSize));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory) {
        return ExecutorWrapper.wrap(Executors.newScheduledThreadPool(corePoolSize, threadFactory));
    }

    public static final void shutdownAll() {
        ExecutorWrapper.shutdown();
    }

    public static final List<Runnable> shutdownAllNOW() {
        return ExecutorWrapper.shutdownNow();
    }

    static class ConcretePriorityBlockingQueue
    extends PriorityBlockingQueue<Runnable> {
        private ThreadPoolExecutor threadPoolExecutor;
        private int maximumPoolSize;

        ConcretePriorityBlockingQueue() {
        }

        public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
            this.threadPoolExecutor = threadPoolExecutor;
            this.maximumPoolSize = threadPoolExecutor.getMaximumPoolSize();
        }

        @Override
        public boolean offer(Runnable runnable) {
            if (this.threadPoolExecutor == null) {
                return super.offer(runnable);
            }
            return this.threadPoolExecutor.getActiveCount() < this.maximumPoolSize - 1 ? false : super.offer(ExecutorsHelper.getPriorityRunnable(runnable));
        }
    }
}

