/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent;

import java.util.concurrent.ScheduledExecutorService;
import org.coodex.concurrent.Coalition;
import org.coodex.concurrent.ExecutorsHelper;

public abstract class AbstractCoalition<T>
implements Coalition<T> {
    protected final ScheduledExecutorService scheduledExecutorService;
    protected final Coalition.Callback<T> callback;
    protected final int interval;

    public AbstractCoalition(Coalition.Callback<T> c, int interval, ScheduledExecutorService scheduledExecutorService) {
        if (scheduledExecutorService == null) {
            throw new NullPointerException("scheduledExecutorService is null.");
        }
        this.scheduledExecutorService = scheduledExecutorService;
        this.callback = c;
        this.interval = interval;
    }

    public AbstractCoalition(Coalition.Callback<T> c, int interval) {
        this(c, interval, ExecutorsHelper.newSingleThreadScheduledExecutor());
    }

    public void terminate() {
        this.scheduledExecutorService.shutdownNow();
    }
}

