/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.coodex.concurrent.AbstractCoalition;
import org.coodex.concurrent.Coalition;

public class Throttler<T>
extends AbstractCoalition<T> {
    private ScheduledFuture prevFuture = null;
    private long prevTime = 0L;

    public Throttler(Coalition.Callback<T> c, int interval, ScheduledExecutorService scheduledExecutorService) {
        super(c, interval, scheduledExecutorService);
    }

    public Throttler(Coalition.Callback<T> c, int interval) {
        super(c, interval);
    }

    private long getNextThrottle() {
        long l = System.currentTimeMillis() - this.prevTime;
        return l > (long)this.interval ? 0L : l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void call(final T key) {
        Throttler throttler = this;
        synchronized (throttler) {
            if (this.prevFuture != null) {
                this.prevFuture.cancel(true);
            }
            long next = this.getNextThrottle();
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Throttler throttler = Throttler.this;
                    synchronized (throttler) {
                        Throttler.this.prevTime = System.currentTimeMillis();
                        Throttler.this.prevFuture = null;
                        Throttler.this.callback.call(key);
                    }
                }
            };
            if (next == 0L) {
                runnable.run();
            } else {
                this.prevFuture = this.scheduledExecutorService.schedule(runnable, (long)(this.interval / 2), TimeUnit.MILLISECONDS);
            }
        }
    }

    public static void main(String[] args) throws InterruptedException {
        Throttler<String> throttler = new Throttler<String>(new Coalition.Callback<String>(){

            @Override
            public void call(String arg) {
                System.out.println(arg);
            }
        }, 200);
        for (int i = 0; i < 410; ++i) {
            Thread.sleep(20L);
            throttler.call(String.format("%d", i));
        }
        Thread.sleep(200L);
        throttler.terminate();
    }
}

