/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.pojomocker;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.coodex.pojomocker.Mocker;
import org.coodex.pojomocker.MockerFacade;
import org.coodex.pojomocker.annotations.BOOLEAN;
import org.coodex.pojomocker.annotations.BYTE;
import org.coodex.pojomocker.annotations.CHAR;
import org.coodex.pojomocker.annotations.DOUBLE;
import org.coodex.pojomocker.annotations.FLOAT;
import org.coodex.pojomocker.annotations.INTEGER;
import org.coodex.pojomocker.annotations.LONG;
import org.coodex.pojomocker.annotations.SHORT;
import org.coodex.pojomocker.annotations.STRING;

@DefaultAnnotations
public class DefaultMockers
implements Mocker<Annotation> {
    private static final DefaultAnnotations DEFAULT_ANNOTATIONS = DefaultMockers.class.getAnnotation(DefaultAnnotations.class);

    @Override
    public boolean accept(Annotation param) {
        return true;
    }

    @Override
    public Object mock(Annotation mockAnnotation, Class clazz) {
        if (Byte.TYPE == clazz || Byte.class.equals((Object)clazz)) {
            mockAnnotation = DEFAULT_ANNOTATIONS.byteM();
        } else if (Character.TYPE == clazz || Character.class.equals((Object)clazz)) {
            mockAnnotation = DEFAULT_ANNOTATIONS.charM();
        } else if (Short.TYPE == clazz || Short.class.equals((Object)clazz)) {
            mockAnnotation = DEFAULT_ANNOTATIONS.shortM();
        } else if (Integer.TYPE == clazz || Integer.class.equals((Object)clazz)) {
            mockAnnotation = DEFAULT_ANNOTATIONS.intM();
        } else if (Long.TYPE == clazz || Long.class.equals((Object)clazz)) {
            mockAnnotation = DEFAULT_ANNOTATIONS.longM();
        } else if (Float.TYPE == clazz || Float.class.equals((Object)clazz)) {
            mockAnnotation = DEFAULT_ANNOTATIONS.floatM();
        } else if (Double.TYPE == clazz || Double.class.equals((Object)clazz)) {
            mockAnnotation = DEFAULT_ANNOTATIONS.doubleM();
        } else if (Boolean.TYPE == clazz || Boolean.class.equals((Object)clazz)) {
            mockAnnotation = DEFAULT_ANNOTATIONS.booleanM();
        } else if (String.class.equals((Object)clazz)) {
            mockAnnotation = DEFAULT_ANNOTATIONS.stringM();
        } else {
            return null;
        }
        return MockerFacade.MOCKER_LOADER.getServiceInstance(mockAnnotation).mock(mockAnnotation, clazz);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    static @interface DefaultAnnotations {
        public INTEGER intM() default @INTEGER;

        public BYTE byteM() default @BYTE;

        public CHAR charM() default @CHAR;

        public SHORT shortM() default @SHORT;

        public LONG longM() default @LONG;

        public STRING stringM() default @STRING;

        public BOOLEAN booleanM() default @BOOLEAN;

        public FLOAT floatM() default @FLOAT;

        public DOUBLE doubleM() default @DOUBLE;
    }
}

