/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.pojomocker.mockers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.coodex.pojomocker.Mocker;
import org.coodex.pojomocker.annotations.STRING;
import org.coodex.util.Common;
import org.coodex.util.Profile;

public class DefaultStringMocker
implements Mocker<STRING> {
    static char[] getDefaultRange() {
        return Profile.getProfile("mock.properties").getString("default.string.range", "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz:;{}[]`!@#$%^&*()_+-='\",./<>?|\\").toCharArray();
    }

    @Override
    public boolean accept(STRING param) {
        return param != null;
    }

    @Override
    public Object mock(STRING mockAnnotation, Class clazz) {
        int len;
        String[] range;
        if (!Common.isBlank(mockAnnotation.txt()) && (range = this.loadFromTxt(mockAnnotation.txt())) != null && range.length > 0) {
            return Common.random(range);
        }
        if (mockAnnotation.range() != null && mockAnnotation.range().length > 0) {
            return Common.random(mockAnnotation.range());
        }
        int min = Math.max(0, mockAnnotation.minLen());
        int max = Math.max(min, mockAnnotation.maxLen());
        char[] range2 = DefaultStringMocker.getDefaultRange();
        StringBuilder builder = new StringBuilder();
        int n = len = min == max ? min : Common.random(min, max);
        for (int i = 0; i < len; ++i) {
            builder.append(range2[Common.random(range2.length - 1)]);
        }
        return builder.toString();
    }

    private String[] loadFromTxt(String txt) {
        try {
            URL url = Common.getResource(Common.trim(txt, '/', '\\'), DefaultStringMocker.class.getClassLoader());
            BufferedReader reader = null;
            if (url == null) {
                File f = new File(txt);
                if (f.exists()) {
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), Charset.forName("utf8")));
                }
            } else {
                reader = new BufferedReader(new InputStreamReader(url.openStream(), Charset.forName("utf8")));
            }
            if (reader != null) {
                String line;
                ArrayList<String> stringList = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    if (Common.isBlank(line) || line.trim().startsWith("#")) continue;
                    stringList.add(line);
                }
                if (stringList.size() > 0) {
                    return stringList.toArray(new String[0]);
                }
            }
            return null;
        }
        catch (Throwable th) {
            return null;
        }
    }
}

