/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.coodex.util.DigestHelper;
import org.coodex.util.Profile;
import org.coodex.util.UUIDHelper;

public class Common {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final int TO_LOWER = 32;
    private static final String DEFAULT_DELIM = ".-_ /\\";

    public static <T> Set<T> arrayToSet(T[] array) {
        HashSet<T> set = new HashSet<T>();
        for (T t : array) {
            set.add(t);
        }
        return set;
    }

    public static String getUUIDStr() {
        return UUIDHelper.getUUIDString();
    }

    public static String sha1(String content) {
        byte[] buf = content == null ? new byte[]{} : content.getBytes();
        return DigestHelper.sha1(buf);
    }

    public static <T> boolean inArray(T el, T[] array) {
        return Common.findInArray(el, array) >= 0;
    }

    public static <T> int findInArray(T el, T[] array) {
        for (int i = 0; i < array.length; ++i) {
            T t = array[i];
            if (el != t && (t == null || !t.equals(el))) continue;
            return i;
        }
        return -1;
    }

    public static String nullToStr(String str) {
        return str == null ? "" : str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> T deepCopy(T object) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        try {
            oos.writeObject(object);
        }
        finally {
            oos.close();
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        try {
            Serializable serializable = (Serializable)ois.readObject();
            return (T)serializable;
        }
        finally {
            ois.close();
        }
    }

    public static int random(int max) {
        return Common.random(0, max);
    }

    public static int random(int min, int max) {
        return (int)Common.random((long)min, (long)max);
    }

    public static long random(long min, long max) {
        if (min == max) {
            return min;
        }
        float _min = Math.min(min, max);
        float _max = Math.max(min, max);
        return (long)((double)_min + Math.random() * (double)(_max - _min));
    }

    public static double random(double min, double max) {
        if (min == max) {
            return min;
        }
        double _min = Math.min(min, max);
        double _max = Math.max(min, max);
        return _min + Math.random() * (_max - _min);
    }

    public static <K extends Serializable, V extends Serializable> void copyMap(Map<K, V> org, Map<K, V> target) {
        for (Serializable key : org.keySet()) {
            try {
                target.put(Common.deepCopy(key), Common.deepCopy((Serializable)org.get(key)));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        Common.copyStream(is, os, 4096, false, Integer.MAX_VALUE);
    }

    public static void copyStream(InputStream is, OutputStream os, int blockSize, boolean flushPerBlock, int bps) throws IOException {
        byte[] buf = new byte[blockSize];
        int cached = -1;
        long start = Calendar.getInstance().getTimeInMillis();
        long wrote = 0L;
        while ((cached = is.read(buf)) > 0) {
            if (wrote >= (long)bps) {
                long n = wrote / (long)bps;
                wrote %= (long)bps;
                long interval = Calendar.getInstance().getTimeInMillis() - start;
                try {
                    if (interval < 1000L * n) {
                        Thread.sleep(interval);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            start = Calendar.getInstance().getTimeInMillis();
            os.write(buf, 0, cached);
            if (!flushPerBlock) continue;
            os.flush();
            wrote += (long)cached;
        }
        if (!flushPerBlock) {
            os.flush();
        }
    }

    public static String byte2hex(byte[] b) {
        String hs = "";
        for (int n = 0; n < b.length; ++n) {
            String sTmp = Integer.toHexString(b[n] & 0xFF);
            hs = sTmp.length() == 1 ? hs + "0" + sTmp : hs + sTmp;
        }
        return hs.toUpperCase();
    }

    public static <T> Set<T> intersection(Set<T> set1, Set<T> set2) {
        HashSet<T> result = new HashSet<T>();
        result.addAll(set1);
        result.retainAll(set2);
        return result;
    }

    public static <T> Set<T> difference(Set<T> org, Set<T> todiv) {
        HashSet<T> result = new HashSet<T>();
        result.addAll(org);
        result.removeAll(todiv);
        return result;
    }

    private static <T, C extends Collection<T>> C join(C instance, Collection ... collections) {
        if (collections != null && collections.length > 0) {
            for (Collection c : collections) {
                if (c == null) continue;
                instance.addAll(c);
            }
        }
        return instance;
    }

    public static <T> Set<T> join(Collection<T> ... sets) {
        return Common.join(new HashSet(), (Collection[])sets);
    }

    public static String native2AscII(String str) {
        if (str == null) {
            return null;
        }
        char[] charPoints = str.toCharArray();
        StringBuffer strBuf = new StringBuffer();
        for (char ch : charPoints) {
            if (ch < '\u0100') {
                strBuf.append(ch);
                continue;
            }
            strBuf.append("\\u").append(Integer.toHexString(ch));
        }
        return strBuf.toString();
    }

    @Deprecated
    public static File getFile(String fileName) throws IOException {
        return Common.getNewFile(fileName);
    }

    public static File getNewFile(String fileName) throws IOException {
        File f = new File(fileName);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        if (f.exists()) {
            f.delete();
        }
        f.createNewFile();
        return f;
    }

    public static URL getResource(String resource, ClassLoader ... classLoaders) {
        ClassLoader classLoader = null;
        URL url = null;
        classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (url = classLoader.getResource(resource)) != null) {
            return url;
        }
        if (classLoaders != null && classLoaders.length > 0) {
            for (ClassLoader cl : classLoaders) {
                url = cl.getResource(resource);
                if (url == null) continue;
                return url;
            }
        }
        if ((classLoader = Common.class.getClassLoader()) != null && (url = classLoader.getResource(resource)) != null) {
            return url;
        }
        return ClassLoader.getSystemResource(resource);
    }

    public static <T> int indexOf(T[] array, T t) {
        if (array == null) {
            throw new NullPointerException("indexOf: array must not be NULL.");
        }
        for (int i = 0; i < array.length; ++i) {
            if (!(t == null ? array[i] == null : t.equals(array[i]))) continue;
            return i;
        }
        return -1;
    }

    public static String concat(List<String> list, String split) {
        if (list == null) {
            return null;
        }
        switch (list.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return list.get(0);
            }
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                builder.append(split);
            }
            builder.append(list.get(i));
        }
        return builder.toString();
    }

    public static int toInt(String str, int value) {
        try {
            return Integer.valueOf(str);
        }
        catch (Throwable th) {
            return value;
        }
    }

    public static long toLong(String str, long value) {
        try {
            return Long.valueOf(str);
        }
        catch (Throwable th) {
            return value;
        }
    }

    public static boolean toBool(String str, boolean v) {
        String s = Common.nullToStr(str);
        if (s.equals("1") || s.equalsIgnoreCase("T") || s.equalsIgnoreCase("TRUE")) {
            return true;
        }
        if (s.equals("0") || s.equalsIgnoreCase("F") || s.equalsIgnoreCase("FALSE")) {
            return false;
        }
        return v;
    }

    public static List<String> toArray(String str, String delim, List<String> v) {
        if (str == null) {
            return v;
        }
        StringTokenizer st = new StringTokenizer(str, delim, false);
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreElements()) {
            list.add(st.nextToken().trim());
        }
        return list;
    }

    public static String[] toArray(String str, String delim, String[] v) {
        List<String> list = Common.toArray(str, delim, v == null ? null : Arrays.asList(v));
        return list == null ? null : list.toArray(new String[0]);
    }

    private static boolean inArray(char ch, char[] chars) {
        for (char c : chars) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    public static String trim(String str, char ... trimChars) {
        int start;
        if (Common.isBlank(str) || trimChars == null || trimChars.length == 0) {
            return str;
        }
        char[] chars = str.toCharArray();
        int end = chars.length;
        for (start = 0; start < end && Common.inArray(chars[start], trimChars); ++start) {
        }
        while (end > start && Common.inArray(chars[end - 1], trimChars)) {
            --end;
        }
        return new String(chars, start, end - start);
    }

    public static String trim(String str, String toTrim) {
        if (Common.isBlank(str) || Common.isBlank(toTrim)) {
            return str;
        }
        return Common.trim(str, toTrim.toCharArray());
    }

    public static boolean sameString(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    public static char randomGB2312Char() {
        try {
            int b1 = Common.random(176, 215);
            int b2 = Common.random(161, b1 == 215 ? 249 : 254);
            return new String(new byte[]{(byte)b1, (byte)b2}, "GB2312").charAt(0);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public static char randomChar(String s) {
        if (Common.isBlank(s)) {
            throw new IllegalArgumentException("range is blank.");
        }
        return s.charAt(Common.random(s.length() - 1));
    }

    public static <T> T random(T[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length - 1)];
    }

    public static byte random(byte[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length - 1)];
    }

    public static short random(short[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length - 1)];
    }

    public static int random(int[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length - 1)];
    }

    public static long random(long[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length - 1)];
    }

    public static float random(float[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length - 1)];
    }

    public static double random(double[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length - 1)];
    }

    public static String randomStr(int min, int max, String range) {
        StringBuilder builder = new StringBuilder();
        int j = Common.random(min, max);
        for (int i = 0; i < j; ++i) {
            builder.append(Common.randomChar(range));
        }
        return builder.toString();
    }

    public static boolean isSameStr(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static Calendar copy(Calendar calendar) {
        return calendar == null ? null : (Calendar)calendar.clone();
    }

    public static String lowerFirstChar(String string) {
        if (string == null) {
            return string;
        }
        char[] charSeq = string.toCharArray();
        if (charSeq.length > 1 && charSeq[0] >= 'A' && charSeq[0] <= 'Z') {
            charSeq[0] = (char)(charSeq[0] + 32);
            return new String(charSeq);
        }
        return string;
    }

    public static String upperFirstChar(String string) {
        if (string == null) {
            return string;
        }
        char[] charSeq = string.toCharArray();
        if (charSeq.length > 1 && charSeq[0] >= 'a' && charSeq[0] <= 'z') {
            charSeq[0] = (char)(charSeq[0] - 32);
            return new String(charSeq);
        }
        return string;
    }

    public static String camelCase(String s) {
        return Common.camelCase(s, false);
    }

    public static String camelCase(String s, String delimiters) {
        return Common.camelCase(s, false, delimiters);
    }

    public static String camelCase(String s, boolean firstCharUpperCase) {
        return Common.camelCase(s, firstCharUpperCase, DEFAULT_DELIM);
    }

    public static String camelCase(String s, boolean firstCharUpperCase, String delimiters) {
        StringTokenizer st = new StringTokenizer(s, delimiters);
        StringBuilder builder = new StringBuilder();
        while (st.hasMoreElements()) {
            String node = st.nextToken();
            if (node.length() == 0) continue;
            builder.append(Common.upperFirstChar(node));
        }
        return firstCharUpperCase ? Common.upperFirstChar(builder.toString()) : Common.lowerFirstChar(builder.toString());
    }

    private static int calculateStringDistance(String strA, String strB) {
        int i;
        int lenA = strA.length();
        int lenB = strB.length();
        int[][] c = new int[lenA + 1][lenB + 1];
        for (i = 0; i < lenA; ++i) {
            c[i][lenB] = lenA - i;
        }
        for (int j = 0; j < lenB; ++j) {
            c[lenA][j] = lenB - j;
        }
        c[lenA][lenB] = 0;
        for (i = lenA - 1; i >= 0; --i) {
            for (int j = lenB - 1; j >= 0; --j) {
                c[i][j] = strB.charAt(j) == strA.charAt(i) ? c[i + 1][j + 1] : Math.min(Math.min(c[i][j + 1], c[i + 1][j]), c[i + 1][j + 1]) + 1;
            }
        }
        return c[0][0];
    }

    public static double similarity(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return 0.0;
        }
        if (s1.equals(s2)) {
            return 1.0;
        }
        return 1.0f - (float)Common.calculateStringDistance(s1, s2) / ((float)Math.max(s1.length(), s2.length()) * 1.0f);
    }

    public static <T> Map<String, T> subMap(String prefix, Map<String, T> map) {
        HashMap<String, T> subMap = new HashMap<String, T>();
        String prefixKey = prefix.endsWith(".") ? prefix : prefix + '.';
        int length = prefixKey.length();
        for (String key : map.keySet()) {
            if (!key.startsWith(prefixKey) || key.length() <= length) continue;
            subMap.put(key.substring(length), map.get(prefixKey));
        }
        return subMap;
    }

    public static void main(String[] args) {
        System.out.println(Profile.getProfile("a.properties").getStrList("aaa"));
    }
}

