/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSACommon {
    public static final boolean isKeyPair(byte[] publicKey, byte[] privateKey) throws InvalidKeySpecException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        SecureRandom random = new SecureRandom();
        byte[] testCase = random.generateSeed(32);
        return RSACommon.verify(publicKey, testCase, RSACommon.sign(privateKey, testCase));
    }

    public static byte[] sign(byte[] privateKey, byte[] content) throws InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        return RSACommon.sign(privateKey, content, "SHA256withRSA");
    }

    public static byte[] sign(byte[] privateKey, byte[] content, String algorithm) throws InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (privateKey == null) {
            throw new InvalidKeyException("no privateKey.");
        }
        RSAPrivateKey rsaPrivateKey = RSACommon.getRSAPrivateKey(privateKey);
        Signature signature = Signature.getInstance(algorithm);
        signature.initSign(rsaPrivateKey);
        signature.update(content);
        return signature.sign();
    }

    public static boolean verify(byte[] publicKey, byte[] content, byte[] signature) throws InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        return RSACommon.verify(publicKey, content, signature, "SHA256withRSA");
    }

    public static boolean verify(byte[] publicKey, byte[] content, byte[] signature, String algorithm) throws InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (publicKey == null) {
            throw new InvalidKeyException("no publicKey.");
        }
        RSAPublicKey rsaPublicKey = RSACommon.getRSAPublicKey(publicKey);
        Signature sign = Signature.getInstance(algorithm);
        sign.initVerify(rsaPublicKey);
        sign.update(content);
        return sign.verify(signature);
    }

    public static final byte[] encrypt(byte[] publicKey, byte[] content) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, IOException {
        RSAPublicKey rsaKey = RSACommon.getRSAPublicKey(publicKey);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, rsaKey);
        return RSACommon.rsaCrypt(content, cipher, rsaKey.getModulus().bitLength() / 8 - 11);
    }

    private static RSAPublicKey getRSAPublicKey(byte[] publicKey) throws InvalidKeySpecException, NoSuchAlgorithmException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
        return (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(keySpec);
    }

    public static final byte[] decrypt(byte[] privateKey, byte[] content) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, IOException {
        RSAPrivateKey rsaKey = RSACommon.getRSAPrivateKey(privateKey);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, rsaKey);
        return RSACommon.rsaCrypt(content, cipher, rsaKey.getModulus().bitLength() / 8);
    }

    private static RSAPrivateKey getRSAPrivateKey(byte[] privateKey) throws InvalidKeySpecException, NoSuchAlgorithmException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKey);
        return (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(keySpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] rsaCrypt(byte[] content, Cipher cipher, int blockSize) throws IOException, IllegalBlockSizeException, BadPaddingException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            int cryptLen;
            for (int remain = content.length; remain > 0; remain -= cryptLen) {
                cryptLen = blockSize > remain ? remain : blockSize;
                result.write(cipher.doFinal(content, content.length - remain, blockSize > remain ? remain : blockSize));
            }
            byte[] byArray = result.toByteArray();
            return byArray;
        }
        finally {
            result.close();
        }
    }
}

