/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.coodex.util.ClassNameFilter;
import org.coodex.util.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectHelper {
    private static Logger log = LoggerFactory.getLogger(ReflectHelper.class);
    public static final ClassDecision NOT_NULL = new NotNullDecision();
    public static final ClassDecision ALL_OBJECT = new AllObjectDecision();
    public static final ClassDecision ALL_OBJECT_EXCEPT_JDK = new AllObjectExceptJavaSDK();

    public static String getParameterName(Method method, int index, String prefix) {
        try {
            return ReflectHelper.getParameterName(method, index);
        }
        catch (Throwable th) {
            return prefix + index;
        }
    }

    public static String getParameterName(Method method, int index) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        String s = ReflectHelper.getParameterNameByAnnotation(method.getParameterAnnotations(), index);
        return s == null ? ReflectHelper.getParameterNameByJava8(method, index) : s;
    }

    private static String getParameterNameByJava8(Method method, int index) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, ClassNotFoundException {
        Method getParameters = Method.class.getMethod("getParameters", new Class[0]);
        Object[] parameters = (Object[])getParameters.invoke((Object)method, new Object[0]);
        if (parameters != null) {
            Class<?> methodParameterClass = Class.forName("java.lang.reflect.Parameter");
            Method getName = methodParameterClass.getMethod("getName", new Class[0]);
            return (String)getName.invoke(parameters[index], new Object[0]);
        }
        return null;
    }

    public static String getParameterName(Constructor constructor, int index, String prefix) {
        try {
            return ReflectHelper.getParameterName(constructor, index);
        }
        catch (Throwable th) {
            return prefix + index;
        }
    }

    private static String getParameterNameByAnnotation(Annotation[][] annotations, int index) {
        if (annotations == null || annotations.length < index) {
            return null;
        }
        for (Annotation annotation : annotations[index]) {
            if (!(annotation instanceof Parameter)) continue;
            return ((Parameter)annotation).value();
        }
        return null;
    }

    public static String getParameterName(Constructor constructor, int index) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        String s = ReflectHelper.getParameterNameByAnnotation(constructor.getParameterAnnotations(), index);
        return s == null ? ReflectHelper.getParameterNameByJava8(constructor, index) : s;
    }

    private static String getParameterNameByJava8(Constructor constructor, int index) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        Method getParameters = Method.class.getMethod("getParameters", new Class[0]);
        Object[] parameters = (Object[])getParameters.invoke((Object)constructor, new Object[0]);
        if (parameters != null) {
            Class<?> methodParameterClass = Class.forName("java.lang.reflect.Parameter");
            Method getName = methodParameterClass.getMethod("getName", new Class[0]);
            return (String)getName.invoke(parameters[index], new Object[0]);
        }
        return null;
    }

    private ReflectHelper() {
    }

    public static Field[] getAllDeclaredFields(Class<?> clz) {
        return ReflectHelper.getAllDeclaredFields(clz, null);
    }

    public static Field[] getAllDeclaredFields(Class<?> clz, ClassDecision decision) {
        if (clz == null) {
            throw new NullPointerException("class is NULL");
        }
        if (decision == null) {
            decision = NOT_NULL;
        }
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Class<?> clazz = clz;
        while (decision.determine(clazz)) {
            Field[] declaredFields = clazz.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                if (fields.containsKey(field.getName())) continue;
                fields.put(field.getName(), field);
            }
            clazz = clazz.getSuperclass();
        }
        return fields.values().toArray(new Field[0]);
    }

    public static boolean belong(Method method, Class<?> clz) {
        try {
            Method m = clz.getMethod(method.getName(), method.getParameterTypes());
            return m != null;
        }
        catch (SecurityException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static Object invoke(Object obj, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (obj == null) {
            throw new NullPointerException("invoke target object is NULL.");
        }
        if (method.getDeclaringClass().isAssignableFrom(obj.getClass())) {
            return method.invoke(obj, args);
        }
        return obj.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke(obj, args);
    }

    public static Collection<Class<?>> getClasses(String packageName) {
        return ReflectHelper.getClasses(packageName, null);
    }

    public static Collection<Class<?>> getClasses(String packageName, ClassNameFilter filter) {
        ClassLoader classLoader = ReflectHelper.class.getClassLoader();
        ArrayList list = new ArrayList();
        String path = packageName.replace('.', '/');
        try {
            Enumeration<URL> resources = classLoader.getResources(path);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                String resource = URLDecoder.decode(url.getFile().replace("+", "%2B"), System.getProperty("file.encoding"));
                int indexOfZipMarker = resource.indexOf(33);
                if (indexOfZipMarker > 0) {
                    list.addAll(ReflectHelper.loadFromZipFile(packageName, filter, new File(resource.substring(5, indexOfZipMarker))));
                    continue;
                }
                File dir = new File(url.toURI());
                list.addAll(ReflectHelper.loadFromDirectory(packageName, filter, dir));
            }
        }
        catch (IOException e) {
            log.warn("{}", (Object)e.getLocalizedMessage(), (Object)e);
        }
        catch (URISyntaxException e) {
            log.warn("{}", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return list;
    }

    private static Collection<Class<?>> loadFromDirectory(String packageName, ClassNameFilter filter, File dir) {
        log.debug("Scan package[{}] in dir[{}]", (Object)packageName, (Object)dir.getAbsolutePath());
        ArrayList result = new ArrayList();
        for (File f : dir.listFiles()) {
            String fileName = f.getName();
            if (f.isDirectory()) {
                result.addAll(ReflectHelper.loadFromDirectory(packageName + "." + fileName, filter, f));
                continue;
            }
            if (!fileName.endsWith(".class")) continue;
            String className = packageName + "." + fileName.substring(0, fileName.length() - 6);
            try {
                if (filter != null && !filter.accept(className)) continue;
                result.add(Class.forName(className));
            }
            catch (Throwable e) {
                log.debug("load Class {} fail. {}", new Object[]{className, e.getLocalizedMessage(), e});
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<Class<?>> loadFromZipFile(String packageName, ClassNameFilter filter, File zipFile) throws IOException {
        ArrayList list = new ArrayList();
        ZipFile zip = new ZipFile(zipFile);
        log.debug("Scan package[{}] in [{}]", (Object)packageName, (Object)zipFile.getAbsolutePath());
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName().replace('/', '.');
                if (!entryName.startsWith(packageName) || !entryName.endsWith(".class")) continue;
                String className = entryName.substring(0, entryName.length() - 6);
                try {
                    if (filter != null && !filter.accept(className)) continue;
                    list.add(Class.forName(className));
                }
                catch (ClassNotFoundException e) {
                    log.debug("load Class {} fail. {}", new Object[]{className, e.getLocalizedMessage(), e});
                }
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            zip.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void foreachClass(Processor processor, ClassNameFilter filter, String ... packages) {
        if (processor == null) {
            return;
        }
        HashSet submittedClasses = new HashSet();
        try {
            for (String pkg : packages) {
                for (Class<?> clazz : ReflectHelper.getClasses(pkg, filter)) {
                    if (submittedClasses.contains(clazz)) continue;
                    processor.process(clazz);
                    submittedClasses.add(clazz);
                }
            }
        }
        finally {
            submittedClasses.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void foreachClass(Processor processor, Class<?> ... classes) {
        if (processor == null) {
            return;
        }
        HashSet submittedClasses = new HashSet();
        try {
            for (Class<?> clazz : classes) {
                if (submittedClasses.contains(clazz)) continue;
                processor.process(clazz);
                submittedClasses.add(clazz);
            }
        }
        finally {
            submittedClasses.clear();
        }
    }

    public static <T> T throwExceptionObject(Class<T> interfaceClass, final Throwable th) {
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                throw th;
            }
        });
    }

    private static class AllObjectExceptJavaSDK
    implements ClassDecision {
        private AllObjectExceptJavaSDK() {
        }

        @Override
        public boolean determine(Class<?> clz) {
            return clz != null && !clz.getPackage().getName().startsWith("java");
        }
    }

    private static class AllObjectDecision
    implements ClassDecision {
        private AllObjectDecision() {
        }

        @Override
        public boolean determine(Class<?> clz) {
            return clz != null && clz != Object.class;
        }
    }

    private static class NotNullDecision
    implements ClassDecision {
        private NotNullDecision() {
        }

        @Override
        public boolean determine(Class<?> clz) {
            return clz != null;
        }
    }

    public static interface ClassDecision {
        public boolean determine(Class<?> var1);
    }

    public static class MethodParameter {
        private final Method method;
        private final int index;
        private String name;
        private Annotation[] annotations;
        private Class<?> type;
        private Type genericType;

        public MethodParameter(Method method, int index) {
            this.method = method;
            this.index = index;
            this.annotations = method.getParameterAnnotations()[index];
            this.type = method.getParameterTypes()[index];
            this.genericType = method.getGenericParameterTypes()[index];
            this.name = ReflectHelper.getParameterName(method, index, "p");
        }

        public Class<?> getType() {
            return this.type;
        }

        public Type getGenericType() {
            return this.genericType;
        }

        public Method getMethod() {
            return this.method;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public Annotation[] getAnnotations() {
            return this.annotations;
        }

        public <T> T getAnnotation(Class<T> annotationClass) {
            if (annotationClass == null) {
                throw new IllegalArgumentException("annotationClass is NULL.");
            }
            if (this.annotations == null) {
                return null;
            }
            for (Annotation annotation : this.annotations) {
                if (!annotationClass.isAssignableFrom(annotation.getClass())) continue;
                return (T)annotation;
            }
            return null;
        }
    }

    public static interface Processor {
        public void process(Class<?> var1);
    }
}

