/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SingletonMap<K, V> {
    private final Builder<K, V> builder;
    private Map<K, V> map = new ConcurrentHashMap();

    public SingletonMap(Builder<K, V> builder) {
        if (builder == null) {
            throw new NullPointerException("builder MUST NOT be null.");
        }
        this.builder = builder;
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getInstance(K key) {
        if (!this.map.containsKey(key)) {
            Map<K, V> map = this.map;
            synchronized (map) {
                if (!this.map.containsKey(key)) {
                    this.map.put(key, this.builder.build(key));
                }
            }
        }
        return this.map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        if (this.map.containsKey(key)) {
            Map<K, V> map = this.map;
            synchronized (map) {
                if (this.map.containsKey(key)) {
                    return this.map.remove(key);
                }
            }
        }
        return null;
    }

    public static interface Builder<K, V> {
        public V build(K var1);
    }
}

