/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.coodex.util.Common;

public class Parallel {
    private static RunnerWrapper defaultWrapper = new RunnerWrapper(){

        @Override
        public Runnable wrap(Runnable runnable) {
            return runnable;
        }
    };
    private final ExecutorService executorService;
    private final RunnerWrapper wrapper;

    public Parallel(ExecutorService executorService) {
        this(executorService, null);
    }

    public Parallel(ExecutorService executorService, RunnerWrapper wrapper) {
        this.executorService = executorService;
        this.wrapper = wrapper == null ? defaultWrapper : wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Batch run(Runnable ... runnables) {
        Batch batch = new Batch();
        batch.start = Calendar.getInstance();
        int i = 1;
        for (Runnable runnable : runnables) {
            batch.getTasks().add(this.newTask(this.wrapper.wrap(runnable), i++, batch));
        }
        while (!batch.isAllFinished()) {
            Batch batch2 = batch;
            synchronized (batch2) {
                try {
                    batch.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        batch.end = Calendar.getInstance();
        return batch;
    }

    private Task newTask(final Runnable runnable, int i, final Object lock) {
        final Task task = new Task();
        task.id = i;
        this.executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                task.start = Calendar.getInstance();
                try {
                    runnable.run();
                }
                catch (Throwable th) {
                    task.throwable = th;
                }
                finally {
                    task.end = Calendar.getInstance();
                    task.finished = true;
                    Object object = lock;
                    synchronized (object) {
                        lock.notify();
                    }
                }
            }
        });
        return task;
    }

    public static class Batch {
        private List<Task> tasks = new ArrayList<Task>();
        private String id = Common.getUUIDStr();
        private Calendar start;
        private Calendar end;

        public long getTimeConsuming() {
            return this.end.getTimeInMillis() - this.start.getTimeInMillis();
        }

        public List<Task> getTasks() {
            return this.tasks;
        }

        public String getId() {
            return this.id;
        }

        public Calendar getStart() {
            return this.start;
        }

        public Calendar getEnd() {
            return this.end;
        }

        public boolean isAllFinished() {
            for (Task task : this.tasks) {
                if (task.isFinished()) continue;
                return false;
            }
            return true;
        }
    }

    public static class Task {
        private Calendar start;
        private Calendar end;
        private Throwable throwable;
        private boolean finished = false;
        private Integer id;

        public long getTimeConsuming() {
            return this.end.getTimeInMillis() - this.start.getTimeInMillis();
        }

        public Calendar getStart() {
            return this.start;
        }

        public Calendar getEnd() {
            return this.end;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public Integer getId() {
            return this.id;
        }

        public boolean isFinished() {
            return this.finished;
        }
    }

    public static interface RunnerWrapper {
        public Runnable wrap(Runnable var1);
    }
}

