/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.io;

import java.io.IOException;
import java.io.OutputStream;

public class SpeedLimitedOutputStream
extends OutputStream {
    private final OutputStream outputStream;
    private final int speedLimit;
    private long lastCountTime = 0L;
    private int wroteBytesFromLastCountTime = 0;

    public SpeedLimitedOutputStream(OutputStream outputStream, int speedLimit) {
        this.outputStream = outputStream;
        this.speedLimit = speedLimit;
    }

    private void startCount() {
        this.lastCountTime = System.currentTimeMillis();
        this.wroteBytesFromLastCountTime = 0;
    }

    private void check(int size) {
        if (this.speedLimit == Integer.MAX_VALUE) {
            return;
        }
        if (this.lastCountTime == 0L) {
            this.startCount();
        }
        this.wroteBytesFromLastCountTime += size;
        if (this.wroteBytesFromLastCountTime >= this.speedLimit) {
            long toSleep = 1000L - (System.currentTimeMillis() - this.lastCountTime);
            if (toSleep > 0L) {
                try {
                    Thread.sleep(toSleep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.startCount();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int toWrote = Math.min(this.speedLimit, len);
            this.outputStream.write(b, off, toWrote);
            this.check(toWrote);
            off += toWrote;
            len -= toWrote;
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
        this.check(1);
    }
}

