/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.pojomocker;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.coodex.pojomocker.COLLECTION;
import org.coodex.pojomocker.Deep;
import org.coodex.pojomocker.DefaultMockers;
import org.coodex.pojomocker.MAP;
import org.coodex.pojomocker.Mock;
import org.coodex.pojomocker.Mocker;
import org.coodex.pojomocker.PojoBuilder;
import org.coodex.pojomocker.PojoBuilderImpl;
import org.coodex.pojomocker.Relation;
import org.coodex.pojomocker.RelationPolicy;
import org.coodex.util.AcceptableServiceLoader;
import org.coodex.util.Common;
import org.coodex.util.GenericType;
import org.coodex.util.PojoInfo;
import org.coodex.util.PojoProperty;
import org.coodex.util.ReflectHelper;
import org.coodex.util.ServiceLoaderFacade;
import org.coodex.util.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockerFacade {
    private static final Logger log = LoggerFactory.getLogger(MockerFacade.class);
    private static final PojoBuilder DEFAULT_BUILDER = new PojoBuilderImpl();
    private static final PojoBuilder POJO_BUILDER = (PojoBuilder)new ServiceLoaderFacade<PojoBuilder>(){

        @Override
        public PojoBuilder getDefaultProvider() {
            return DEFAULT_BUILDER;
        }
    }.getInstance();
    private static final DefaultMockers DEFAULT_MOCKER = new DefaultMockers();
    static final AcceptableServiceLoader<Annotation, Mocker<Annotation>> MOCKER_LOADER = new AcceptableServiceLoader(new ServiceLoaderFacade<Mocker<Annotation>>(){

        @Override
        public Mocker<Annotation> getDefaultProvider() {
            return DEFAULT_MOCKER;
        }
    });
    private static final AcceptableServiceLoader<String, RelationPolicy> RELATION_POLICY_LOADER = new AcceptableServiceLoader(new ServiceLoaderFacade<RelationPolicy>(){});
    private static final Map<String, PojoInfo> POJO_INFO_MAP = new HashMap<String, PojoInfo>();

    public static <T> T mock(GenericType<T> genericType) {
        return MockerFacade.mock(genericType, null);
    }

    public static <T> T mock(GenericType<T> genericType, Class context) {
        return MockerFacade.mock(genericType.genericType(context));
    }

    public static <T> T mock(Type type) {
        return MockerFacade.mock(type, (Class[])null);
    }

    public static <T> T mock(Method method) {
        return MockerFacade.mock(method, (Class[])null);
    }

    public static <T> T mock(final Method method, Class ... context) {
        Type type = TypeHelper.toTypeReference(method.getGenericReturnType(), context);
        if (type instanceof TypeVariable) {
            throw new RuntimeException(MockerFacade.typeVariableInfo(type, context));
        }
        try {
            return MockerFacade.$mock(type, new PojoProperty(null, type){

                @Override
                public Annotation[] getAnnotations() {
                    return method.getAnnotations();
                }
            }, 0, null, context);
        }
        catch (MaxDeepException e) {
            return null;
        }
    }

    public static <T> T mock(Type type, Class ... context) {
        if ((type = TypeHelper.toTypeReference(type, context)) instanceof TypeVariable) {
            throw new RuntimeException(MockerFacade.typeVariableInfo(type, context));
        }
        try {
            return MockerFacade.$mock(type, null, 0, null, context);
        }
        catch (MaxDeepException e) {
            return null;
        }
    }

    private static String typeVariableInfo(Type type, Class ... context) {
        StringBuilder builder = new StringBuilder("TypeVariable is NOT supported.[");
        builder.append(type).append(" declared in ");
        Object declaration = ((TypeVariable)type).getGenericDeclaration();
        if (declaration instanceof Class) {
            builder.append(((Class)declaration).getName());
        } else if (declaration instanceof Method) {
            builder.append(MockerFacade.executableDeclaration((Method)declaration, context));
        } else if (declaration instanceof Constructor) {
            builder.append(MockerFacade.executableDeclaration((Constructor)declaration, context));
        }
        return builder.append(']').toString();
    }

    private static String executableDeclaration(Method method, Class ... context) {
        StringBuilder builder = new StringBuilder();
        builder.append(method.getDeclaringClass().getName()).append(".").append(method.getName()).append('(');
        int i = 0;
        for (Type t : method.getGenericParameterTypes()) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(TypeHelper.toTypeReference(t, context)).append(' ').append(ReflectHelper.getParameterName(method, i, "arg"));
        }
        return builder.append(')').toString();
    }

    private static String executableDeclaration(Constructor constructor, Class ... context) {
        StringBuilder builder = new StringBuilder();
        builder.append(constructor.getDeclaringClass().getName()).append('(');
        int i = 0;
        for (Type t : constructor.getGenericParameterTypes()) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(TypeHelper.toTypeReference(t, context)).append(' ').append(ReflectHelper.getParameterName(constructor, i, "arg"));
        }
        return builder.append(')').toString();
    }

    private static <T> T $mock(Type type, PojoProperty property, int dimension, Stack<String> stack, Type ... context) throws MaxDeepException {
        if (type == null) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            return MockerFacade.mockParameterizedType((ParameterizedType)type, property, dimension, stack, context);
        }
        if (type instanceof GenericArrayType) {
            return MockerFacade.mockGenericArray((GenericArrayType)type, property, dimension, stack, context);
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return MockerFacade.mockArray(clazz, property, dimension, stack, context);
            }
            return MockerFacade.mockClass(clazz, property, dimension, stack, context);
        }
        return null;
    }

    private static final <T> T mockParameterizedType(ParameterizedType type, PojoProperty property, int dimension, Stack<String> stack, Type ... context) throws MaxDeepException {
        Class c = (Class)type.getRawType();
        if (Collection.class.isAssignableFrom(c)) {
            return MockerFacade.mockCollection(c, type.getActualTypeArguments()[0], property, dimension, stack, context);
        }
        if (Map.class.isAssignableFrom(c)) {
            return MockerFacade.mockMap(c, type.getActualTypeArguments()[0], type.getActualTypeArguments()[1], property, dimension, stack, context);
        }
        return MockerFacade.mockPojo(new PojoInfo(type, context), property, stack, context);
    }

    private static final <T> T mockGenericArray(GenericArrayType type, PojoProperty property, int dimension, Stack<String> stack, Type ... context) throws MaxDeepException {
        Type componentType = TypeHelper.toTypeReference(type.getGenericComponentType(), context);
        int size = MockerFacade.getArraySize(property, dimension);
        Object array = Array.newInstance(MockerFacade.getComponentClass(componentType, context), size);
        for (int i = 0; i < size; ++i) {
            if (componentType instanceof GenericArrayType) {
                Array.set(array, i, MockerFacade.mockGenericArray((GenericArrayType)componentType, property, dimension + 1, stack, context));
                continue;
            }
            if (componentType instanceof ParameterizedType) {
                Array.set(array, i, MockerFacade.mockParameterizedType((ParameterizedType)componentType, property, dimension + 1, stack, context));
                continue;
            }
            throw new RuntimeException("unsupported component type: " + componentType.toString());
        }
        return (T)array;
    }

    public static final Class getComponentClass(Type componentType, Type ... context) {
        if (componentType == null || componentType instanceof TypeVariable) {
            return Object.class;
        }
        if (componentType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)componentType).getRawType();
        }
        if (componentType instanceof Class) {
            return (Class)componentType;
        }
        if (componentType instanceof GenericArrayType) {
            return Array.newInstance(MockerFacade.getComponentClass(((GenericArrayType)componentType).getGenericComponentType(), context), 0).getClass();
        }
        return null;
    }

    private static final Annotation getAnnotation(PojoProperty property) {
        if (property == null) {
            return null;
        }
        for (Annotation annotation : property.getAnnotations()) {
            if (annotation == null || annotation.annotationType().getAnnotation(Mock.class) == null) continue;
            return annotation;
        }
        return null;
    }

    private static final <T> T mockClass(Class clazz, PojoProperty property, int dimension, Stack<String> stack, Type ... context) throws MaxDeepException {
        if (Collection.class.isAssignableFrom(clazz)) {
            return MockerFacade.mockCollection(clazz, null, property, dimension, stack, context);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return MockerFacade.mockMap(clazz, null, null, property, dimension, stack, context);
        }
        if (TypeHelper.isPrimitive(clazz)) {
            Annotation annotation = MockerFacade.getAnnotation(property);
            return (T)MOCKER_LOADER.getServiceInstance(annotation).mock(annotation, clazz);
        }
        Annotation annotation = MockerFacade.getAnnotation(property);
        if (annotation != null) {
            return (T)MOCKER_LOADER.getServiceInstance(annotation).mock(annotation, clazz);
        }
        return MockerFacade.mockPojo(new PojoInfo(clazz, context), property, stack, context);
    }

    private static final <T extends Map> T mockMap(Class<? extends Map> mapClass, Type keyType, Type valueType, PojoProperty property, int dimension, Stack<String> stack, Type ... context) throws MaxDeepException {
        Map<T, T> map = null;
        if (Map.class.equals(mapClass)) {
            map = new HashMap();
        } else {
            try {
                map = mapClass.newInstance();
            }
            catch (Throwable th) {
                throw new RuntimeException("unable init map: " + th.getLocalizedMessage(), th);
            }
        }
        MAP annotation = property.getAnnotation(MAP.class);
        int size = 5;
        Annotation keyMocker = null;
        Annotation valueMocker = null;
        if (annotation != null) {
            size = Math.max(1, annotation.size());
            keyMocker = (Annotation)property.getAnnotation(annotation.keyMocker());
            valueMocker = (Annotation)property.getAnnotation(annotation.valueMocker());
            if (keyType == null) {
                keyType = annotation.keyType();
            }
            if (valueType == null) {
                valueType = annotation.valueType();
            }
        }
        if (keyType == null) {
            keyType = String.class;
        }
        if (valueType == null) {
            valueType = String.class;
        }
        while (map.size() < size) {
            final Annotation finalKeyMocker = keyMocker;
            T key = MockerFacade.$mock((Type)keyType, keyMocker == null ? null : new PojoProperty(property, (Type)keyType){

                @Override
                public Annotation[] getAnnotations() {
                    return new Annotation[]{finalKeyMocker};
                }
            }, dimension, stack, context);
            final Annotation finalValueMocker = valueMocker;
            T value = MockerFacade.$mock((Type)valueType, valueMocker == null ? null : new PojoProperty(property, (Type)valueType){

                @Override
                public Annotation[] getAnnotations() {
                    return new Annotation[]{finalValueMocker};
                }
            }, dimension, stack, context);
            map.put(key, value);
        }
        return (T)map;
    }

    private static final <T extends Collection> T mockCollection(Class<? extends Collection> collectionClass, Type componentType, PojoProperty property, int dimension, Stack<String> stack, Type ... context) throws MaxDeepException {
        Collection<T> collection = null;
        if (List.class.equals(collectionClass)) {
            collection = new ArrayList();
        } else if (Set.class.equals(collectionClass)) {
            collection = new HashSet();
        } else {
            try {
                collection = collectionClass.newInstance();
            }
            catch (Throwable th) {
                throw new RuntimeException("unable init collection: " + th.getLocalizedMessage(), th);
            }
        }
        if (componentType == null) {
            componentType = Object.class;
        }
        int size = MockerFacade.getArraySize(property, dimension);
        for (int i = 0; i < size; ++i) {
            collection.add(MockerFacade.$mock(TypeHelper.toTypeReference((Type)componentType, context), property, dimension + 1, stack, context));
        }
        return (T)collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PojoInfo getPojoInfo(Type type, Type ... context) {
        Map<String, PojoInfo> map = POJO_INFO_MAP;
        synchronized (map) {
            type = TypeHelper.toTypeReference(type, context);
            if (!POJO_INFO_MAP.containsKey(type.toString())) {
                POJO_INFO_MAP.put(type.toString(), new PojoInfo(type, context));
            }
        }
        return POJO_INFO_MAP.get(type.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T mockPojo(PojoInfo pojoInfo, PojoProperty property, Stack<String> stack, Type ... context) throws MaxDeepException {
        if (stack == null) {
            stack = new Stack();
        }
        stack.push(pojoInfo.getType().toString());
        try {
            int deep = MockerFacade.getDeep(property);
            String pojoType = pojoInfo.getType().toString();
            for (String s : stack) {
                if (!pojoType.equals(s) || --deep >= 0) continue;
                throw new MaxDeepException();
            }
            HashMap<String, List<String>> relations = new HashMap<String, List<String>>();
            for (PojoProperty pojoProperty : pojoInfo.getProperties()) {
                Relation relation = pojoProperty.getAnnotation(Relation.class);
                if (relations.containsKey(pojoProperty.getName()) || relation == null || relation.properties() == null || relation.properties().length <= 0) continue;
                relations.put(pojoProperty.getName(), Arrays.asList(relation.properties()));
                List list = (List)relations.get(pojoProperty.getName());
                for (String dependency : list) {
                    if (pojoInfo.getProperty(dependency) != null) continue;
                    throw new RuntimeException("property not exists: " + dependency);
                }
                MockerFacade.checkCircular(relations, list, pojoProperty.getName());
            }
            Object object = MockerFacade.buildPojo(pojoInfo, stack, context);
            return (T)object;
        }
        finally {
            stack.pop();
        }
    }

    private static void checkCircular(Map<String, List<String>> relations, List<String> dependencies, String propertyName) {
        if (dependencies == null || dependencies.size() == 0) {
            return;
        }
        for (String s : dependencies) {
            if (propertyName.equals(s)) {
                throw new RuntimeException("circular relation: " + propertyName);
            }
            MockerFacade.checkCircular(relations, relations.get(s), propertyName);
        }
    }

    private static Object buildPojo(PojoInfo pojoInfo, Stack<String> stack, Type ... context) {
        Object instance = null;
        try {
            instance = POJO_BUILDER.newInstance(pojoInfo);
        }
        catch (Throwable th) {
            throw new RuntimeException("Cannot instance type: " + pojoInfo.getType().toString() + ", caused by: " + th.getLocalizedMessage(), th);
        }
        HashSet<String> over = new HashSet<String>();
        for (PojoProperty pojoProperty : pojoInfo.getProperties()) {
            try {
                MockerFacade.buildProperty(instance, over, stack, pojoInfo, pojoProperty, context);
            }
            catch (Throwable th) {
                String message = "Cannot set property: " + pojoProperty.getName() + ", caused by: " + th.getLocalizedMessage();
                if ("warn".equalsIgnoreCase(System.getProperty(Mock.POLICY_KEY))) {
                    log.warn("{}", (Object)message, (Object)th);
                    continue;
                }
                throw new RuntimeException(message, th);
            }
        }
        return instance;
    }

    private static void buildProperty(Object instance, Set<String> over, Stack<String> stack, PojoInfo pojoInfo, PojoProperty pojoProperty, Type[] context) throws Throwable {
        if (over.contains(pojoProperty.getName())) {
            return;
        }
        Relation relation = pojoProperty.getAnnotation(Relation.class);
        if (relation != null && relation.properties() != null && relation.properties().length > 0) {
            ArrayList<Object> dependencies = new ArrayList<Object>();
            for (String property : relation.properties()) {
                PojoProperty p = pojoInfo.getProperty(property);
                MockerFacade.buildProperty(instance, over, stack, pojoInfo, p, context);
                dependencies.add(POJO_BUILDER.get(instance, p));
            }
            POJO_BUILDER.set(instance, pojoProperty, RELATION_POLICY_LOADER.getServiceInstance(relation.policy()).relate(relation.policy(), dependencies));
        } else {
            try {
                POJO_BUILDER.set(instance, pojoProperty, MockerFacade.$mock(pojoProperty.getType(), pojoProperty, 0, stack, context));
            }
            catch (MaxDeepException e) {
                POJO_BUILDER.set(instance, pojoProperty, null);
            }
        }
        over.add(pojoProperty.getName());
    }

    private static int getDeep(PojoProperty property) {
        Deep deep;
        int deepMin = 2;
        int deepMax = 5;
        if (property != null && (deep = property.getAnnotation(Deep.class)) != null) {
            deepMin = Math.max(1, deep.min());
            deepMax = Math.max(deep.max(), deepMin);
        }
        return Common.random(deepMin, deepMax);
    }

    private static int getArraySize(PojoProperty property, int dimension) {
        COLLECTION collectionAnnotation;
        int[] arraySize = COLLECTION.DEFAULT_SIZE;
        if (property != null && (collectionAnnotation = property.getAnnotation(COLLECTION.class)) != null) {
            arraySize = collectionAnnotation.size();
        }
        int size = -1;
        if (dimension < arraySize.length) {
            size = arraySize[dimension];
        } else if (arraySize.length > 0) {
            size = arraySize[arraySize.length - 1];
        }
        return size < 0 ? Common.random(1, 10) : size;
    }

    private static <T> T mockArray(Class clazz, PojoProperty pojoProperty, int dimension, Stack<String> stack, Type ... context) throws MaxDeepException {
        Class<?> componentClass = clazz.getComponentType();
        int arraySize = MockerFacade.getArraySize(pojoProperty, dimension);
        Object array = Array.newInstance(componentClass, arraySize);
        for (int i = 0; i < arraySize; ++i) {
            Array.set(array, i, componentClass.isArray() ? MockerFacade.mockArray(componentClass, pojoProperty, dimension + 1, stack, context) : MockerFacade.mockClass(componentClass, pojoProperty, dimension + 1, stack, context));
        }
        return (T)array;
    }

    private static class MaxDeepException
    extends Exception {
        private MaxDeepException() {
        }
    }
}

