/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.coodex.util.AcceptableService;
import org.coodex.util.ServiceLoader;
import org.coodex.util.ServiceLoaderFacade;
import org.coodex.util.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceptableServiceLoader<Param_Type, T extends AcceptableService<Param_Type>>
implements ServiceLoader<T> {
    private static final Logger log = LoggerFactory.getLogger(AcceptableServiceLoader.class);
    private final ServiceLoaderFacade<T> serviceLoaderFacade;

    public AcceptableServiceLoader(ServiceLoaderFacade<T> serviceLoaderFacade) {
        this.serviceLoaderFacade = serviceLoaderFacade;
    }

    private boolean accept(T instance, Param_Type param) {
        Class<?> paramClass;
        Class<?> tClass = instance.getClass();
        Class<?> clazz = paramClass = param == null ? null : param.getClass();
        if (paramClass == null) {
            return instance.accept(null);
        }
        Class required = TypeHelper.typeToClass(TypeHelper.solve(AcceptableService.class.getTypeParameters()[0], tClass));
        if (required != null && required.isAssignableFrom(paramClass)) {
            return instance.accept(param);
        }
        return false;
    }

    public List<T> getServiceInstances(Param_Type param) {
        ArrayList<AcceptableService> list = new ArrayList<AcceptableService>();
        for (AcceptableService instance : this.getAllInstances()) {
            if (!this.accept(instance, param)) continue;
            list.add(instance);
        }
        try {
            AcceptableService instance = (AcceptableService)this.serviceLoaderFacade.getDefaultProvider();
            if (this.accept(instance, param)) {
                list.add(instance);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return list;
    }

    public T getServiceInstance(Param_Type param) {
        for (AcceptableService instance : this.getAllInstances()) {
            if (!this.accept(instance, param)) continue;
            return (T)instance;
        }
        try {
            AcceptableService instance = (AcceptableService)this.serviceLoaderFacade.getDefaultProvider();
            if (this.accept(instance, param)) {
                return (T)instance;
            }
            if (instance.accept(param)) {
                return (T)instance;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        log.info("no service instance accept this: {}", param);
        return null;
    }

    @Override
    public Collection<T> getAllInstances() {
        return this.serviceLoaderFacade.getAllInstances();
    }

    @Override
    public T getInstance(Class<? extends T> providerClass) {
        return (T)((AcceptableService)this.serviceLoaderFacade.getInstance(providerClass));
    }

    @Override
    public T getInstance(String name) {
        return (T)((AcceptableService)this.serviceLoaderFacade.getInstance(name));
    }

    @Override
    public T getInstance() {
        return (T)((AcceptableService)this.serviceLoaderFacade.getInstance());
    }

    @Override
    public Map<String, T> getInstances() {
        return this.serviceLoaderFacade.getInstances();
    }
}

