/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.coodex.util.CRC;
import org.coodex.util.Common;

public class ByteArrayBuilder {
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private final Endianness endianness;

    public ByteArrayBuilder() {
        this(Endianness.LITTLE_ENDIAN);
    }

    public ByteArrayBuilder(Endianness endianness) {
        this.endianness = endianness;
    }

    public ByteArrayBuilder append(byte b) {
        this.byteArrayOutputStream.write(b & 0xFF);
        return this;
    }

    public ByteArrayBuilder append(byte[] buf) {
        this.byteArrayOutputStream.write(buf, 0, buf.length);
        return this;
    }

    public ByteArrayBuilder append(byte[] buf, int off, int len) {
        this.byteArrayOutputStream.write(buf, off, len);
        return this;
    }

    private byte[] toBytes(long l, int wide, Endianness endianness) {
        byte[] bytes = new byte[wide];
        boolean little = Endianness.LITTLE_ENDIAN.equals((Object)endianness);
        for (int i = 0; i < wide; ++i) {
            bytes[little ? i : wide - i - 1] = (byte)l;
            l >>>= 8;
        }
        return bytes;
    }

    public ByteArrayBuilder append(short word) {
        return this.append(word, this.endianness);
    }

    public ByteArrayBuilder append(short word, Endianness endianness) {
        return this.append(this.toBytes(word & 0xFFFF, 2, endianness));
    }

    public ByteArrayBuilder append(int i) {
        return this.append(i, this.endianness);
    }

    public ByteArrayBuilder append(int i, Endianness endianness) {
        return this.append(this.toBytes((long)i & 0xFFFFFFFFL, 4, endianness));
    }

    public ByteArrayBuilder append(long l, Endianness endianness) {
        return this.append(this.toBytes(l, 8, endianness));
    }

    public ByteArrayBuilder append(long l) {
        return this.append(l, this.endianness);
    }

    public ByteArrayBuilder append(String string) {
        return this.append(string.getBytes());
    }

    public ByteArrayBuilder append(String string, String charsetName) {
        try {
            return this.append(string.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw Common.runtimeException(e);
        }
    }

    public ByteArrayBuilder append(CRC.Algorithm algorithm) {
        return this.append(algorithm, this.endianness);
    }

    public ByteArrayBuilder append(CRC.Algorithm algorithm, int off, int len) {
        return this.append(algorithm, off, len, this.endianness);
    }

    public ByteArrayBuilder append(CRC.Algorithm algorithm, Endianness endianness) {
        return this.append(algorithm, 0, this.byteArrayOutputStream.size(), endianness);
    }

    public ByteArrayBuilder append(CRC.Algorithm algorithm, int off, int len, Endianness endianness) {
        return this.append(this.toBytes(CRC.calculateCRC(algorithm, this.byteArrayOutputStream.toByteArray(), off, len), algorithm.getParameters().getWidth() / 8, endianness));
    }

    public byte[] build() {
        return this.byteArrayOutputStream.toByteArray();
    }

    public static enum Endianness {
        BIG_ENDIAN,
        LITTLE_ENDIAN;

    }
}

