/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.coodex.concurrent.ExecutorsHelper;
import org.coodex.util.Common;
import org.coodex.util.Singleton;
import org.coodex.util.StringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Profile
implements StringMap {
    private static final String RELOAD_INTERVAL = System.getProperty("Profile.reloadInterval");
    private static final Logger log = LoggerFactory.getLogger(Profile.class);
    private static final Map<String, Profile> profiles = new HashMap<String, Profile>();
    private static Singleton<ScheduledExecutorService> RELOAD_POOL = new Singleton<ScheduledExecutorService>(new Singleton.Builder<ScheduledExecutorService>(){

        @Override
        public ScheduledExecutorService build() {
            return ExecutorsHelper.newSingleThreadScheduledExecutor();
        }
    });
    private static Set<String> notFound = new HashSet<String>();
    protected Properties p = new Properties();
    private long lastModified = 0L;
    private String resourcePath;
    private File f;
    private String location;
    private InputStream is;
    private Runnable reloadTask = new Runnable(){

        @Override
        public void run() {
            block6: {
                try {
                    if (Profile.this.f == null) {
                        Profile.this.loadFromPath(Profile.this.resourcePath, true);
                        break block6;
                    }
                    if (Profile.this.f.lastModified() == Profile.this.lastModified) break block6;
                    Profile.this.lastModified = Profile.this.f.lastModified();
                    try {
                        Profile.this.is = new FileInputStream(Profile.this.f);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    Profile.this.load();
                }
                finally {
                    Profile.this.submitReloadTask();
                }
            }
        }
    };

    protected Profile(String path) {
        this.resourcePath = path;
        this.loadFromPath(path);
        this.submitReloadTask();
    }

    private static ScheduledExecutorService getReloadPool() {
        return RELOAD_POOL.getInstance();
    }

    public static synchronized Profile getProfile(String path) {
        Profile p = profiles.get(path);
        if (p == null) {
            p = new Profile(path);
            profiles.put(path, p);
        }
        return p;
    }

    public static InputStream getResourceAsStream(String resourcePath) throws IOException {
        URL url = Profile.getResource(Common.trim(resourcePath, '/'));
        return url == null ? new FileInputStream(resourcePath) : url.openStream();
    }

    public static URL getResource(String resource) {
        ClassLoader classLoader = null;
        URL url = null;
        classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (url = classLoader.getResource(resource)) != null) {
            return url;
        }
        classLoader = Profile.class.getClassLoader();
        if (classLoader != null && (url = classLoader.getResource(resource)) != null) {
            return url;
        }
        return ClassLoader.getSystemResource(resource);
    }

    private void loadFromPath(String path) {
        this.loadFromPath(path, false);
    }

    private void submitReloadTask() {
        long inteval = -1L;
        try {
            inteval = Long.parseLong(RELOAD_INTERVAL);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (inteval > 0L) {
            ScheduledExecutorService pool = Profile.getReloadPool();
            if (pool.isShutdown() || pool.isTerminated()) {
                return;
            }
            pool.schedule(this.reloadTask, inteval, TimeUnit.SECONDS);
        }
    }

    private synchronized void loadFromPath(String path, boolean reload) {
        URL uri;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((uri = Profile.class.getResource(path)) == null) {
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            uri = Profile.getResource(path);
        }
        if (uri != null) {
            this.location = uri.toString();
            if (this.location.indexOf(33) >= 0) {
                this.f = null;
                this.is = Profile.class.getResourceAsStream(path);
            } else {
                this.f = new File(uri.getFile());
                try {
                    this.is = new FileInputStream(this.f);
                    this.lastModified = this.f.lastModified();
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            this.load();
        } else if (!reload && !notFound.contains(path)) {
            notFound.add(path);
            log.info("Profile [" + path + "] not found.");
        }
    }

    public String getLocation() {
        return this.location;
    }

    public Properties getProperties() {
        this.check();
        return this.p;
    }

    private synchronized void check() {
    }

    private void load() {
        try {
            this.p.clear();
            if (this.is != null) {
                this.p.load(this.is);
                this.is.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void store(String comments) {
        if (this.f == null) {
            return;
        }
        try {
            this.p.store(new FileOutputStream(this.f), comments);
            this.lastModified = this.f.lastModified();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean getBool(String key) {
        return this.getBool(key, false);
    }

    public boolean getBool(String key, boolean v) {
        this.check();
        return Common.toBool(this.p.getProperty(key), v);
    }

    @Override
    public String getString(String key, String v) {
        this.check();
        String s = this.p.getProperty(key);
        if (s == null) {
            return this.resolve(key, v);
        }
        return s == null ? v : s;
    }

    private String resolve(String key, String v) {
        return v;
    }

    @Override
    public String getString(String key) {
        return this.getString(key, null);
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int v) {
        return Common.toInt(this.getString(key), v);
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long v) {
        return Common.toLong(this.getString(key), v);
    }

    public String[] getStrList(String key) {
        return this.getStrList(key, ",");
    }

    public String[] getStrList(String key, String delim) {
        return this.getStrList(key, delim, null);
    }

    public String[] getStrList(String key, String delim, String[] v) {
        this.check();
        return Common.toArray(this.getString(key), delim, v);
    }

    public void setString(String key, String value) {
        this.setString(key, value, true);
    }

    public void setString(String key, String value, boolean acceptNull) {
        if (!acceptNull && value == null) {
            return;
        }
        this.setProperty(key, value, false);
    }

    public void setInt(String key, int value, int unchange) {
        if (value != unchange) {
            this.setProperty(key, String.valueOf(value), false);
        }
    }

    public void setLong(String key, long value, long unchange) {
        if (value != unchange) {
            this.setProperty(key, String.valueOf(value), false);
        }
    }

    public void setInt(String key, int value) {
        this.setProperty(key, String.valueOf(value), false);
    }

    public void setLong(String key, long value) {
        this.setProperty(key, String.valueOf(value), false);
    }

    private void setProperty(String key, String value, boolean store) {
        String s = this.getString(key);
        if (s == value) {
            return;
        }
        if (s != null && s.equals(value)) {
            return;
        }
        this.p.setProperty(key, value == null ? "" : value);
        if (store) {
            this.store("");
        }
    }

    public synchronized void setProperty(String key, String value) {
        this.setProperty(key, value, true);
    }

    public void setStrList(String key, String[] list) {
        if (list == null) {
            this.setProperty(key, null);
            return;
        }
        String s = "";
        for (int i = 0; i < list.length; ++i) {
            s = s + list[i] + ",";
        }
        this.setProperty(key, s);
    }

    public void setBool(String key, boolean v) {
        this.setProperty(key, v ? "true" : "false");
    }
}

