/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import org.coodex.util.Common;
import org.coodex.util.Profile;
import org.coodex.util.StringMap;

public class RecursivelyProfile {
    private final StringMap profile;

    public RecursivelyProfile(Profile profile) {
        this.profile = profile;
    }

    public RecursivelyProfile(final Properties properties) {
        this.profile = new StringMap(){

            @Override
            public String getString(String key) {
                return this.getString(key, null);
            }

            @Override
            public String getString(String key, String defaultValue) {
                return properties == null ? defaultValue : properties.getProperty(key, defaultValue);
            }
        };
    }

    public String getString(String namespace, String key, String value) {
        String result = this.getString(namespace, key);
        return result == null ? value : result;
    }

    public String getString(String namespace, String key) {
        String search;
        Stack<String> toSearch = new Stack<String>();
        toSearch.push(key);
        if (!Common.isBlank(namespace)) {
            StringTokenizer stringTokenizer = new StringTokenizer(namespace, ".", false);
            StringBuilder builder = new StringBuilder();
            while (stringTokenizer.hasMoreTokens()) {
                String token = stringTokenizer.nextToken();
                if (Common.isBlank(token)) continue;
                if (builder.length() > 0) {
                    builder.append(".");
                }
                builder.append(token);
                toSearch.push(builder.toString() + "." + key);
            }
        }
        String result = null;
        while (toSearch.size() > 0 && (result = this.profile.getString(search = (String)toSearch.pop())) == null) {
        }
        return result;
    }
}

