/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.coodex.util.ServiceLoader;
import org.coodex.util.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceLoaderFacade<T>
implements ServiceLoader<T> {
    private static final Logger log = LoggerFactory.getLogger(ServiceLoaderFacade.class);
    private Map<String, T> instances = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        ServiceLoaderFacade serviceLoaderFacade = this;
        synchronized (serviceLoaderFacade) {
            if (this.instances == null) {
                this.loadInstances();
            }
        }
    }

    protected Class<T> getInterfaceClass() {
        this.load();
        return TypeHelper.typeToClass(TypeHelper.solve(ServiceLoaderFacade.class.getTypeParameters()[0], this.getClass()));
    }

    public T getDefaultProvider() {
        this.load();
        throw new RuntimeException("no provider found for: " + this.getInterfaceClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadInstances() {
        if (this.instances == null) {
            ServiceLoaderFacade serviceLoaderFacade = this;
            synchronized (serviceLoaderFacade) {
                if (this.instances == null) {
                    this.instances = new HashMap<String, T>();
                    java.util.ServiceLoader<T> loader = java.util.ServiceLoader.load(this.getInterfaceClass());
                    for (T service : loader) {
                        if (service == null) continue;
                        this.instances.put(service.getClass().getCanonicalName(), service);
                    }
                    if (this.instances.size() == 0) {
                        log.debug("no ServiceProvider found for [{}], using default provider.", (Object)this.getInterfaceClass().getCanonicalName());
                    }
                }
            }
        }
    }

    @Override
    public Collection<T> getAllInstances() {
        this.load();
        return this.instances.values();
    }

    protected Map<String, T> $getInstances() {
        this.load();
        return this.instances;
    }

    @Override
    public Map<String, T> getInstances() {
        this.load();
        return new HashMap<String, T>(this.$getInstances());
    }

    @Override
    public T getInstance(Class<? extends T> providerClass) {
        this.load();
        HashMap<String, T> copy = new HashMap<String, T>();
        for (String key : this.instances.keySet()) {
            T t = this.instances.get(key);
            if (t == null || !providerClass.isAssignableFrom(t.getClass())) continue;
            copy.put(key, t);
        }
        switch (copy.size()) {
            case 0: {
                throw null;
            }
            case 1: {
                return (T)copy.values().iterator().next();
            }
        }
        return this.conflict(providerClass, copy);
    }

    protected T conflict(Class<? extends T> providerClass, Map<String, T> map) {
        T t = this.getInstance(providerClass.getName());
        if (t != null) {
            return t;
        }
        StringBuffer buffer = new StringBuffer(this.getInterfaceClass().getName());
        buffer.append("[providerClass: ").append(providerClass.getName()).append("]");
        buffer.append(" has ").append(map.size()).append(" services:[");
        for (T service : map.values()) {
            buffer.append("\n\t").append(service.getClass().getName());
        }
        buffer.append("]");
        throw new RuntimeException(buffer.toString());
    }

    @Override
    public T getInstance(String name) {
        this.load();
        T instance = this.instances.get(name);
        return instance == null ? this.getDefaultProvider() : instance;
    }

    protected T conflict() {
        StringBuffer buffer = new StringBuffer(this.getInterfaceClass().getName());
        buffer.append(" has ").append(this.instances.size()).append(" services:[");
        for (T service : this.instances.values()) {
            buffer.append("\n\t").append(service.getClass().getName());
        }
        buffer.append("]");
        throw new RuntimeException(buffer.toString());
    }

    @Override
    public T getInstance() {
        this.load();
        if (this.instances.size() == 0) {
            return this.getDefaultProvider();
        }
        if (this.instances.size() == 1) {
            return (T)this.instances.values().toArray()[0];
        }
        return this.conflict();
    }
}

