/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.coodex.concurrent.ExecutorsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonMap<K, V> {
    private static final Logger log = LoggerFactory.getLogger(SingletonMap.class);
    private final Builder<K, V> builder;
    private long maxAge = 0L;
    private ScheduledExecutorService scheduledExecutorService;
    private Map<K, V> map = new ConcurrentHashMap();

    public SingletonMap(Builder<K, V> builder) {
        if (builder == null) {
            throw new NullPointerException("builder MUST NOT be null.");
        }
        this.builder = builder;
    }

    public SingletonMap(Builder<K, V> builder, long maxAge) {
        this(builder);
        this.maxAge = maxAge;
        if (maxAge > 0L) {
            this.scheduledExecutorService = ExecutorsHelper.newSingleThreadScheduledExecutor();
        }
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getInstance(final K key) {
        if (!this.map.containsKey(key)) {
            Map<K, V> map = this.map;
            synchronized (map) {
                if (!this.map.containsKey(key)) {
                    V o = this.builder.build(key);
                    this.map.put(key, o);
                    if (this.maxAge > 0L) {
                        this.scheduledExecutorService.schedule(new Runnable(){

                            @Override
                            public void run() {
                                log.debug("{} die.", key);
                                SingletonMap.this.remove(key);
                            }
                        }, this.maxAge, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }
        return this.map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        if (this.map.containsKey(key)) {
            Map<K, V> map = this.map;
            synchronized (map) {
                if (this.map.containsKey(key)) {
                    return this.map.remove(key);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<V> values() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return this.map.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<K, V> map = this.map;
        synchronized (map) {
            if (this.map.size() > 0) {
                this.map.clear();
            }
        }
    }

    public static interface Builder<K, V> {
        public V build(K var1);
    }
}

