/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.coodex.util.Common;
import org.coodex.util.TypeHelper$$;

public class TypeHelper {
    private static final ExceptClassFilter javaLangExceptFilter = new JavaLangExceptFilter();
    private static final Class[] PRIMITIVE_CLASSES = new Class[]{String.class, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class, Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};

    public static Class typeToClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return null;
    }

    public static Type toTypeReference(Type type, Type ... contextClass) {
        if (type instanceof ParameterizedType) {
            return TypeHelper.buildParameterizedType((ParameterizedType)type, contextClass);
        }
        if (type instanceof TypeVariable) {
            return TypeHelper.solve((TypeVariable)type, contextClass);
        }
        if (type instanceof GenericArrayType) {
            return TypeHelper.buildGenericArrayType((GenericArrayType)type, contextClass);
        }
        return type;
    }

    public static Type solve(TypeVariable variable, Type ... types) {
        if (types == null || types.length == 0) {
            return null;
        }
        if (variable.getGenericDeclaration() instanceof Class) {
            Type t = TypeHelper.toTypeReference(TypeHelper.solveClassTypeVariable(variable, types), types);
            return t == null ? variable : t;
        }
        return variable;
    }

    private static Type solveClassTypeVariable(TypeVariable variable, Type ... types) {
        Class declaration = (Class)variable.getGenericDeclaration();
        Type $ = null;
        for (Type t : types) {
            if ((t = TypeHelper.isSuper(declaration, t)) == null) continue;
            if (t instanceof Class) {
                $ = TypeHelper.solveInClass(variable, (Class)t);
            } else if (t instanceof ParameterizedType) {
                $ = TypeHelper.solveInParameterizedType(variable, (ParameterizedType)t);
            }
            if ($ instanceof TypeVariable) {
                $ = TypeHelper.solve((TypeVariable)$, types);
                continue;
            }
            if ($ instanceof ParameterizedType) {
                return TypeHelper.buildParameterizedType((ParameterizedType)$, types);
            }
            if ($ instanceof GenericArrayType) {
                return TypeHelper.buildGenericArrayType((GenericArrayType)$, types);
            }
            if ($ != null) break;
        }
        return $;
    }

    private static Type buildGenericArrayType(GenericArrayType $, Type ... types) {
        return $ instanceof $$GenericArrayType ? $ : new $$GenericArrayType($, types, null);
    }

    private static Type buildParameterizedType(ParameterizedType $, Type ... types) {
        return $ instanceof $$ParameterizedType ? $ : new $$ParameterizedType($, types);
    }

    private static Type solveInClass(TypeVariable variable, Class c) {
        Type $;
        int n;
        int n2;
        Type[] typeArray;
        if (c == null) {
            return null;
        }
        Type result = TypeHelper.toTypeReference(TypeHelper.solveInSuper(variable, c.getGenericSuperclass()), c);
        if (result == null) {
            typeArray = c.getGenericInterfaces();
            n2 = typeArray.length;
            for (n = 0; n < n2 && (result = TypeHelper.solveInSuper(variable, $ = typeArray[n])) == null; ++n) {
            }
        }
        if (result == null) {
            result = TypeHelper.solveInClass(variable, c.getSuperclass());
        }
        if (result == null) {
            typeArray = c.getInterfaces();
            n2 = typeArray.length;
            for (n = 0; n < n2 && (result = TypeHelper.solveInClass(variable, (Class)($ = typeArray[n]))) == null; ++n) {
            }
        }
        return result;
    }

    private static Type solveInSuper(TypeVariable variable, Type superType) {
        if (superType instanceof Class) {
            return TypeHelper.solveInClass(variable, (Class)superType);
        }
        if (superType instanceof ParameterizedType) {
            return TypeHelper.solveInParameterizedType(variable, (ParameterizedType)superType);
        }
        return null;
    }

    private static Type solveInParameterizedType(TypeVariable variable, ParameterizedType pt) {
        Class declaringClass = (Class)variable.getGenericDeclaration();
        if (declaringClass.equals(pt.getRawType())) {
            TypeVariable<Class<T>>[] t = declaringClass.getTypeParameters();
            for (int i = 0; i < t.length; ++i) {
                if (!variable.equals(t[i])) continue;
                return pt.getActualTypeArguments()[i];
            }
        } else {
            return TypeHelper.solveClassTypeVariable(variable, pt.getActualTypeArguments());
        }
        return null;
    }

    private static Type isSuper(Class<?> c, Type toTest) {
        if (toTest == null || c == null) {
            return null;
        }
        if (toTest instanceof Class) {
            Class toTestClass = (Class)toTest;
            return toTestClass.isArray() ? TypeHelper.isSuper(c, ((Class)toTest).getComponentType()) : (c.isAssignableFrom(toTestClass) ? toTestClass : null);
        }
        if (toTest instanceof ParameterizedType) {
            return toTest;
        }
        if (toTest instanceof GenericArrayType) {
            return TypeHelper.isSuper(c, ((GenericArrayType)toTest).getGenericComponentType());
        }
        return null;
    }

    public static boolean isPrimitive(Class c) {
        return Common.inArray(c, PRIMITIVE_CLASSES);
    }

    private static class JavaLangExceptFilter
    implements ExceptClassFilter {
        private JavaLangExceptFilter() {
        }

        @Override
        public boolean except(Class<?> c) {
            return c.getPackage().getName().startsWith("java.lang");
        }
    }

    public static interface ExceptClassFilter {
        public boolean except(Class<?> var1);
    }
}

