/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.coodex.util.Clock;

final class ExecutorWrapper {
    private static final Set<ExecutorService> executors = new HashSet<ExecutorService>();

    ExecutorWrapper() {
    }

    static <T extends ExecutorService> T wrap(T executorService) {
        if (executorService instanceof ScheduledExecutorService) {
            final ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)executorService;
            executorService = (ExecutorService)Proxy.newProxyInstance(ScheduledExecutorService.class.getClassLoader(), scheduledExecutorService.getClass().getInterfaces(), new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object[] argsCopy = args;
                    if (method.getDeclaringClass().equals(ScheduledExecutorService.class)) {
                        if (args != null && args.length > 0) {
                            argsCopy = new Object[args.length];
                            System.arraycopy(args, 0, argsCopy, 0, args.length);
                        }
                        if (argsCopy != null && argsCopy.length == 2 && "schedule".equals(method.getName())) {
                            argsCopy[1] = Clock.toMillis((Long)args[1], (TimeUnit)((Object)args[2]));
                            argsCopy[2] = TimeUnit.MILLISECONDS;
                        } else if (argsCopy != null && argsCopy.length == 2 && ("scheduleAtFixedRate".equals(method.getName()) || "scheduleWithFixedDelay".equals(method.getName()))) {
                            argsCopy[1] = Clock.toMillis((Long)args[1], (TimeUnit)((Object)args[3]));
                            argsCopy[2] = Clock.toMillis((Long)args[2], (TimeUnit)((Object)args[3]));
                            argsCopy[3] = TimeUnit.MILLISECONDS;
                        }
                    }
                    if (argsCopy == null || argsCopy.length == 0) {
                        return method.invoke((Object)scheduledExecutorService, new Object[0]);
                    }
                    return method.invoke((Object)scheduledExecutorService, argsCopy);
                }
            });
        }
        executors.add((ExecutorService)executorService);
        return executorService;
    }

    static void shutdown() {
        for (ExecutorService service : executors) {
            if (service == null || service.isShutdown() || service.isTerminated()) continue;
            service.shutdown();
        }
    }

    static List<Runnable> shutdownNow() {
        ArrayList<Runnable> list = new ArrayList<Runnable>();
        for (ExecutorService service : executors) {
            if (service == null || service.isTerminated()) continue;
            list.addAll(service.shutdownNow());
        }
        return list;
    }
}

