/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.coodex.util.Clock;
import org.coodex.util.Common;

public class Parallel {
    private static RunnerWrapper defaultWrapper = new RunnerWrapper(){

        @Override
        public Runnable wrap(Runnable runnable) {
            return runnable;
        }
    };
    private final ExecutorService executorService;
    private final RunnerWrapper wrapper;

    public Parallel() {
        this(null);
    }

    public Parallel(ExecutorService executorService) {
        this(executorService, null);
    }

    public Parallel(ExecutorService executorService, RunnerWrapper wrapper) {
        this.executorService = executorService;
        this.wrapper = wrapper == null ? defaultWrapper : wrapper;
    }

    public Batch run(Runnable ... runnables) {
        Batch batch = new Batch();
        batch.start = Clock.getCalendar();
        if (runnables != null && runnables.length > 0) {
            CountDownLatch latch = new CountDownLatch(runnables.length);
            int i = 1;
            for (Runnable runnable : runnables) {
                batch.getTasks().add(this.newTask(this.wrapper.wrap(runnable), i++, latch));
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
        batch.end = Clock.getCalendar();
        return batch;
    }

    private Task newTask(final Runnable runnable, int i, final CountDownLatch latch) {
        final Task task = new Task();
        task.id = i;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                task.start = Clock.getCalendar();
                try {
                    runnable.run();
                }
                catch (Throwable th) {
                    task.throwable = th;
                }
                finally {
                    task.end = Clock.getCalendar();
                    task.finished = true;
                    latch.countDown();
                }
            }
        };
        if (this.executorService != null) {
            this.executorService.execute(run);
        } else {
            new Thread(run).start();
        }
        return task;
    }

    public static class Batch {
        private List<Task> tasks = new ArrayList<Task>();
        private String id = Common.getUUIDStr();
        private Calendar start;
        private Calendar end;

        public long getTimeConsuming() {
            return this.end.getTimeInMillis() - this.start.getTimeInMillis();
        }

        public List<Task> getTasks() {
            return this.tasks;
        }

        public String getId() {
            return this.id;
        }

        public Calendar getStart() {
            return this.start;
        }

        public Calendar getEnd() {
            return this.end;
        }
    }

    public static class Task {
        private Calendar start;
        private Calendar end;
        private Throwable throwable;
        private boolean finished = false;
        private Integer id;

        public long getTimeConsuming() {
            return this.end.getTimeInMillis() - this.start.getTimeInMillis();
        }

        public Calendar getStart() {
            return this.start;
        }

        public Calendar getEnd() {
            return this.end;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public Integer getId() {
            return this.id;
        }

        public boolean isFinished() {
            return this.finished;
        }
    }

    public static interface RunnerWrapper {
        public Runnable wrap(Runnable var1);
    }
}

