/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent.locks;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.coodex.concurrent.locks.ResourceId;
import org.coodex.concurrent.locks.ResourceLock;
import org.coodex.util.Clock;

public abstract class AbstractResourceLock
implements ResourceLock {
    private final ResourceId resourceId;
    private ReentrantLock lock = new ReentrantLock();
    private long lastActive = Clock.currentTimeMillis();

    public AbstractResourceLock(ResourceId resourceId) {
        this.resourceId = resourceId;
    }

    protected abstract void alloc();

    protected abstract boolean allocated();

    protected abstract void release();

    protected abstract boolean tryAlloc();

    protected abstract boolean tryAlloc(long var1);

    public AbstractResourceLock active() {
        this.lastActive = Clock.currentTimeMillis();
        return this;
    }

    public long getLastActive() {
        return this.lastActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() {
        this.active();
        this.lock.lock();
        if (!this.allocated()) {
            AbstractResourceLock abstractResourceLock = this;
            synchronized (abstractResourceLock) {
                if (!this.allocated()) {
                    try {
                        this.alloc();
                    }
                    catch (RuntimeException re) {
                        this.lock.unlock();
                        throw re;
                    }
                }
            }
        }
    }

    public boolean isDeath() {
        return this.lastActive + 10000L < Clock.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock() {
        this.active();
        boolean locked = this.lock.tryLock();
        if (locked && !this.allocated()) {
            AbstractResourceLock abstractResourceLock = this;
            synchronized (abstractResourceLock) {
                if (!this.allocated()) {
                    if (this.tryAlloc()) {
                        return true;
                    }
                    this.lock.unlock();
                    locked = false;
                }
            }
        }
        return locked;
    }

    private long toMillis(long time, TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return time / 1000000L;
            }
            case MICROSECONDS: {
                return time / 1000L;
            }
            case MILLISECONDS: {
                return time;
            }
            case SECONDS: {
                return time * 1000L;
            }
            case MINUTES: {
                return time * 1000L * 60L;
            }
            case HOURS: {
                return time * 1000L * 60L * 60L;
            }
            case DAYS: {
                return time * 1000L * 60L * 60L * 24L;
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        this.active();
        long deathLine = Clock.currentTimeMillis() + this.toMillis(time, unit);
        boolean locked = this.lock.tryLock(time, unit);
        if (locked && !this.allocated()) {
            AbstractResourceLock abstractResourceLock = this;
            synchronized (abstractResourceLock) {
                if (!this.allocated()) {
                    if (this.tryAlloc(deathLine - Clock.currentTimeMillis())) {
                        return true;
                    }
                    this.lock.unlock();
                    locked = false;
                }
            }
        }
        return locked;
    }

    @Override
    public void unlock() {
        this.active();
        if (this.lock.getQueueLength() == 0 && this.lock.getHoldCount() == 1) {
            this.release();
        }
        this.lock.unlock();
    }

    public ResourceId getId() {
        return this.resourceId;
    }
}

