/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.config;

import java.util.ArrayList;
import java.util.List;
import org.coodex.config.Configuration;
import org.coodex.util.Common;

public abstract class AbstractConfiguration
implements Configuration {
    @Override
    public <T> T getValue(String key, T defaultValue, String ... namespace) {
        return Common.to(this.get(key, namespace), defaultValue);
    }

    @Override
    public String get(String key, String ... namespaces) {
        List<String> ns = this.toList(namespaces);
        return this.search(key, ns == null || ns.size() == 0 ? null : ns, ns == null ? -1 : ns.size());
    }

    protected List<String> toList(String ... namespaces) {
        if (namespaces == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String namespace : namespaces) {
            if (Common.isBlank(namespace)) continue;
            list.add(namespace);
        }
        return list;
    }

    private List<String> buildKeys(String key, List<String> namespaces, int deep) {
        ArrayList<String> keys = new ArrayList<String>();
        if (namespaces != null) {
            for (int i = deep - 1; i < namespaces.size(); ++i) {
                String temp = "";
                for (int j = i + 1; j < namespaces.size(); ++j) {
                    temp = temp + namespaces.get(deep - 1 + j - i) + ".";
                }
                keys.add(temp + key);
            }
        } else {
            keys.add(key);
        }
        return keys;
    }

    private String buildNamespace(List<String> namespaces, int len) {
        if (len == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                builder.append('.');
            }
            builder.append(namespaces.get(i));
        }
        return builder.toString();
    }

    protected String search(String key, List<String> namespaces, int deep) {
        List<String> keys;
        if (deep == -1) {
            return null;
        }
        String namespace = this.buildNamespace(namespaces, deep);
        String value = this.search(namespace, keys = this.buildKeys(key, namespaces, deep));
        return value == null ? this.search(key, namespaces, deep - 1) : value;
    }

    protected abstract String search(String var1, List<String> var2);
}

