/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.pojomocker;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.coodex.closure.CallableClosure;
import org.coodex.closure.MapClosureContext;
import org.coodex.pojomocker.COLLECTION;
import org.coodex.pojomocker.Deep;
import org.coodex.pojomocker.DefaultMockers;
import org.coodex.pojomocker.MAP;
import org.coodex.pojomocker.Mock;
import org.coodex.pojomocker.Mocker;
import org.coodex.pojomocker.MockerDef;
import org.coodex.pojomocker.MockerRef;
import org.coodex.pojomocker.PojoBuilder;
import org.coodex.pojomocker.PojoBuilderImpl;
import org.coodex.pojomocker.Relation;
import org.coodex.pojomocker.RelationPolicy;
import org.coodex.pojomocker.Sequence;
import org.coodex.pojomocker.SequenceGenerator;
import org.coodex.pojomocker.Sequences;
import org.coodex.util.AcceptableServiceLoader;
import org.coodex.util.Common;
import org.coodex.util.GenericType;
import org.coodex.util.PojoInfo;
import org.coodex.util.PojoProperty;
import org.coodex.util.ReflectHelper;
import org.coodex.util.ServiceLoader;
import org.coodex.util.ServiceLoaderImpl;
import org.coodex.util.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MockerFacade {
    private static final Logger log = LoggerFactory.getLogger(MockerFacade.class);
    private static final PojoBuilder DEFAULT_BUILDER = new PojoBuilderImpl();
    private static final PojoBuilder POJO_BUILDER = (PojoBuilder)new ServiceLoaderImpl<PojoBuilder>(){

        @Override
        public PojoBuilder getDefault() {
            return DEFAULT_BUILDER;
        }
    }.get();
    private static final DefaultMockers DEFAULT_MOCKER = new DefaultMockers();
    static final AcceptableServiceLoader<Annotation, Mocker<Annotation>> MOCKER_LOADER = new AcceptableServiceLoader<Annotation, Mocker<Annotation>>((ServiceLoader)new ServiceLoaderImpl<Mocker<Annotation>>(){

        @Override
        public Mocker<Annotation> getDefault() {
            return DEFAULT_MOCKER;
        }
    }){};
    private static final AcceptableServiceLoader<String, RelationPolicy> RELATION_POLICY_LOADER = new AcceptableServiceLoader<String, RelationPolicy>((ServiceLoader)new ServiceLoaderImpl<RelationPolicy>(){}){};
    private static final SequenceContext SEQUENCE_CONTEXT = new SequenceContext();
    private static final MockerRefContext MOCKER_REF_CONTEXT = new MockerRefContext();

    private static SequenceGenerator buildSequenceGenerator(Sequence sequence) {
        if (sequence == null) {
            return null;
        }
        try {
            SequenceGenerator generator = sequence.sequenceType().newInstance();
            generator.setKey(sequence.key());
            return generator;
        }
        catch (Throwable e) {
            throw Common.runtimeException(e);
        }
    }

    public static <T> T mock(GenericType<T> genericType) {
        return MockerFacade.mock(genericType, null);
    }

    public static <T> T mock(GenericType<T> genericType, Class context) {
        return MockerFacade.mock(genericType.genericType(context));
    }

    public static <T> T mock(Type type) {
        return MockerFacade.mock(type, (Class[])null);
    }

    public static <T> T mock(Method method) {
        return MockerFacade.mock(method, (Class[])null);
    }

    public static <T> T mock(final Method method, Class ... context) {
        Type type = TypeHelper.toTypeReference(method.getGenericReturnType(), context);
        if (type instanceof TypeVariable) {
            throw new RuntimeException(MockerFacade.typeVariableInfo(type, context));
        }
        try {
            return MockerFacade.$mock(type, new PojoProperty(null, type){

                @Override
                public Annotation[] getAnnotations() {
                    return method.getAnnotations();
                }
            }, 0, null, context);
        }
        catch (MaxDeepException e) {
            return null;
        }
    }

    public static <T> T mock(Type type, Class ... context) {
        if ((type = TypeHelper.toTypeReference(type, context)) instanceof TypeVariable) {
            throw new RuntimeException(MockerFacade.typeVariableInfo(type, context));
        }
        try {
            return MockerFacade.$mock(type, null, 0, null, context);
        }
        catch (MaxDeepException e) {
            return null;
        }
    }

    private static String typeVariableInfo(Type type, Class ... context) {
        StringBuilder builder = new StringBuilder("TypeVariable is NOT supported.[");
        builder.append(type).append(" declared in ");
        Object declaration = ((TypeVariable)type).getGenericDeclaration();
        if (declaration instanceof Class) {
            builder.append(((Class)declaration).getName());
        } else if (declaration instanceof Method) {
            builder.append(MockerFacade.executableDeclaration((Method)declaration, context));
        } else if (declaration instanceof Constructor) {
            builder.append(MockerFacade.executableDeclaration((Constructor)declaration, context));
        }
        return builder.append(']').toString();
    }

    private static String executableDeclaration(Method method, Class ... context) {
        return method.getDeclaringClass().getName() + "." + method.getName() + '(' + MockerFacade.parametersDeclaration(method, method.getGenericParameterTypes(), context) + ')';
    }

    private static String parametersDeclaration(Object executable, Type[] paramTyps, Class ... context) {
        StringBuilder builder = new StringBuilder();
        int l = paramTyps.length;
        for (int i = 0; i < l; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(TypeHelper.toTypeReference(paramTyps[i], context)).append(' ').append(ReflectHelper.getParameterName(executable, i, "arg"));
        }
        return builder.toString();
    }

    private static String executableDeclaration(Constructor constructor, Class ... context) {
        return constructor.getDeclaringClass().getName() + '(' + MockerFacade.parametersDeclaration(constructor, constructor.getGenericParameterTypes(), context) + ')';
    }

    private static List<Sequence> getSequence(PojoProperty pojoProperty) {
        Sequence sequence;
        if (pojoProperty == null) {
            return null;
        }
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        Sequences sequencesAnnotation = pojoProperty.getAnnotation(Sequences.class);
        if (sequencesAnnotation != null) {
            sequences.addAll(Arrays.asList(sequencesAnnotation.value()));
        }
        if ((sequence = pojoProperty.getAnnotation(Sequence.class)) != null) {
            sequences.add(sequence);
        }
        return sequences.size() > 0 ? sequences : null;
    }

    private static Object call(CallableClosure callableClosure) throws MaxDeepException {
        try {
            return callableClosure.call();
        }
        catch (MaxDeepException mde) {
            throw mde;
        }
        catch (Throwable th) {
            throw Common.runtimeException(th);
        }
    }

    private static <T> T $mock(final Type type, final PojoProperty property, final int dimension, final Stack<String> stack, final Type ... context) throws MaxDeepException {
        if (type == null) {
            return null;
        }
        CallableClosure callableClosure = new CallableClosure(){

            @Override
            public Object call() throws Throwable {
                if (type instanceof ParameterizedType) {
                    return MockerFacade.mockParameterizedType((ParameterizedType)type, property, dimension, stack, context);
                }
                if (type instanceof GenericArrayType) {
                    return MockerFacade.mockGenericArray((GenericArrayType)type, property, dimension, stack, context);
                }
                if (type instanceof Class) {
                    Class clazz = (Class)type;
                    if (clazz.isArray()) {
                        return MockerFacade.mockArray(clazz, property, dimension, stack, context);
                    }
                    return MockerFacade.mockClass(clazz, property, dimension, stack, context);
                }
                return null;
            }
        };
        callableClosure = MockerFacade.defMockerRefContext(property, callableClosure);
        List<Sequence> sequenceList = MockerFacade.getSequence(property);
        if (sequenceList != null) {
            HashMap<String, SequenceGenerator> generatorMap = new HashMap<String, SequenceGenerator>();
            for (Sequence sequence : sequenceList) {
                generatorMap.put(sequence.key(), MockerFacade.buildSequenceGenerator(sequence));
            }
            return (T)SEQUENCE_CONTEXT.call(generatorMap, callableClosure);
        }
        return (T)MockerFacade.call(callableClosure);
    }

    private static CallableClosure defMockerRefContext(PojoProperty property, CallableClosure callableClosure) {
        Annotation annotation;
        Annotation annotation2 = annotation = property == null ? null : property.findDecoratedBy(MockerDef.class);
        if (annotation != null) {
            Class<? extends Annotation> c = annotation.annotationType();
            final HashMap<String, Annotation> map = new HashMap<String, Annotation>();
            for (Method method : c.getDeclaredMethods()) {
                Annotation mocker = MockerFacade.getAnnotationDecoratedBy(method.getDeclaredAnnotations(), Mock.class);
                if (mocker == null) continue;
                map.put(method.getName(), mocker);
            }
            if (map.size() > 0) {
                final CallableClosure finalCallableClosure = callableClosure;
                callableClosure = new CallableClosure(){

                    @Override
                    public Object call() throws Throwable {
                        return MOCKER_REF_CONTEXT.call(map, finalCallableClosure);
                    }
                };
            }
        }
        return callableClosure;
    }

    private static String getMockerName(Annotation annotation) {
        ReflectiveOperationException th;
        if (annotation == null) {
            return null;
        }
        try {
            Method m = annotation.annotationType().getDeclaredMethod("name", new Class[0]);
            m.setAccessible(true);
            return (String)m.invoke((Object)annotation, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            th = e;
        }
        catch (IllegalAccessException e) {
            th = e;
        }
        catch (InvocationTargetException e) {
            th = e;
        }
        if (th != null) {
            // empty if block
        }
        return null;
    }

    private static <T> T mockArray(Class clazz, final PojoProperty pojoProperty, final int dimension, final Stack<String> stack, final Type ... context) throws MaxDeepException {
        Object array;
        final Class<?> componentClass = clazz.getComponentType();
        int arraySize = MockerFacade.getArraySize(pojoProperty, dimension);
        if (componentClass.isArray()) {
            array = Array.newInstance(componentClass, arraySize);
            for (int i = 0; i < arraySize; ++i) {
                Array.set(array, i, MockerFacade.mockArray(componentClass, pojoProperty, dimension + 1, stack, context));
            }
        } else {
            SequenceGenerator generator = MockerFacade.getGenerator(pojoProperty);
            if (generator != null) {
                generator.reset();
                arraySize = generator.size();
            }
            array = Array.newInstance(componentClass, arraySize);
            final int finalArraySize = arraySize;
            SEQUENCE_CONTEXT.call(generator, new CallableClosure(){

                @Override
                public Object call() throws Throwable {
                    for (int i = 0; i < finalArraySize; ++i) {
                        Array.set(array, i, MockerFacade.mockClass(componentClass, pojoProperty, dimension + 1, stack, context));
                    }
                    return null;
                }
            });
        }
        return (T)array;
    }

    private static <T> T mockParameterizedType(ParameterizedType type, PojoProperty property, int dimension, Stack<String> stack, Type ... context) throws MaxDeepException {
        Class c = (Class)type.getRawType();
        if (Collection.class.isAssignableFrom(c)) {
            return MockerFacade.mockCollection(c, type.getActualTypeArguments()[0], property, dimension, stack, context);
        }
        if (Map.class.isAssignableFrom(c)) {
            return MockerFacade.mockMap(c, type.getActualTypeArguments()[0], type.getActualTypeArguments()[1], property, dimension, stack, context);
        }
        return MockerFacade.mockPojo(new PojoInfo(type, context), property, stack, context);
    }

    private static <T> T mockGenericArray(GenericArrayType type, final PojoProperty property, final int dimension, final Stack<String> stack, final Type ... context) throws MaxDeepException {
        Object array;
        final Type componentType = TypeHelper.toTypeReference(type.getGenericComponentType(), context);
        int size = MockerFacade.getArraySize(property, dimension);
        if (componentType instanceof GenericArrayType) {
            array = Array.newInstance(MockerFacade.getComponentClass(componentType), size);
            for (int i = 0; i < size; ++i) {
                Array.set(array, i, MockerFacade.mockGenericArray((GenericArrayType)componentType, property, dimension + 1, stack, context));
            }
        } else if (componentType instanceof ParameterizedType) {
            SequenceGenerator generator = MockerFacade.getGenerator(property);
            if (generator != null) {
                generator.reset();
                size = generator.size();
            }
            array = Array.newInstance(MockerFacade.getComponentClass(componentType), size);
            final int finalSize = size;
            SEQUENCE_CONTEXT.call(generator, new CallableClosure(){

                @Override
                public Object call() throws Throwable {
                    for (int i = 0; i < finalSize; ++i) {
                        Array.set(array, i, MockerFacade.mockParameterizedType((ParameterizedType)componentType, property, dimension + 1, stack, context));
                    }
                    return null;
                }
            });
        } else {
            throw new RuntimeException("unsupported component type: " + componentType.toString());
        }
        return (T)array;
    }

    public static Class getComponentClass(Type componentType) {
        if (componentType == null || componentType instanceof TypeVariable) {
            return Object.class;
        }
        if (componentType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)componentType).getRawType();
        }
        if (componentType instanceof Class) {
            return (Class)componentType;
        }
        if (componentType instanceof GenericArrayType) {
            return Array.newInstance(MockerFacade.getComponentClass(((GenericArrayType)componentType).getGenericComponentType()), 0).getClass();
        }
        return null;
    }

    private static <T> T mockClass(Class clazz, PojoProperty property, int dimension, Stack<String> stack, Type ... context) throws MaxDeepException {
        MockerRef ref;
        SequenceGenerator generator;
        Sequence.Item item;
        if (Collection.class.isAssignableFrom(clazz)) {
            return MockerFacade.mockCollection(clazz, null, property, dimension, stack, context);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return MockerFacade.mockMap(clazz, null, null, property, dimension, stack, context);
        }
        Sequence.Item item2 = item = property == null ? null : property.getAnnotation(Sequence.Item.class);
        if (item != null && (generator = MockerFacade.getSequenceGenerator(item.key(), item.notFound(), property)) != null) {
            return generator.next();
        }
        Annotation annotation = property == null ? null : property.findDecoratedBy(Mock.class);
        MockerRef mockerRef = ref = property == null ? null : property.getAnnotation(MockerRef.class);
        if (ref != null) {
            Annotation mocker = (Annotation)MOCKER_REF_CONTEXT.get(ref.name());
            if (mocker == null) {
                log.info("mocker reference [{}] not found in context.", (Object)ref.name());
            } else {
                annotation = mocker;
            }
        }
        if (TypeHelper.isPrimitive(clazz)) {
            return (T)MOCKER_LOADER.select(annotation).mock(annotation, clazz);
        }
        if (annotation != null) {
            return (T)MOCKER_LOADER.select(annotation).mock(annotation, clazz);
        }
        return MockerFacade.mockPojo(new PojoInfo(clazz, context), property, stack, context);
    }

    private static <T extends Map> T mockMap(Class<? extends Map> mapClass, Type keyType, Type valueType, PojoProperty property, int dimension, Stack<String> stack, Type ... context) throws MaxDeepException {
        Annotation a;
        Annotation valueMocker;
        Map map;
        if (Map.class.equals(mapClass)) {
            map = new HashMap();
        } else {
            try {
                map = mapClass.newInstance();
            }
            catch (Throwable th) {
                throw new RuntimeException("unable init map: " + th.getLocalizedMessage(), th);
            }
        }
        MAP annotation = property.getAnnotation(MAP.class);
        int size = 5;
        SequenceGenerator keyGenerator = null;
        Annotation keyMocker = null;
        Annotation keyAnnotation = property.findDecoratedBy(MAP.Key.class);
        if (keyAnnotation != null) {
            size = keyAnnotation.annotationType().getAnnotation(MAP.Key.class).size();
            Sequence.Use use = keyAnnotation.annotationType().getAnnotation(Sequence.Use.class);
            if (use != null) {
                keyGenerator = MockerFacade.getSequenceGenerator(use.key(), use.notFound(), property);
            }
            if (keyGenerator == null) {
                Annotation[] sequence = keyAnnotation.annotationType().getAnnotation(Sequence.class);
                keyGenerator = MockerFacade.buildSequenceGenerator((Sequence)sequence);
            }
            if (keyGenerator == null) {
                for (Annotation anno : keyAnnotation.annotationType().getAnnotations()) {
                    if (anno.annotationType().getAnnotation(Mock.class) == null) continue;
                    keyMocker = anno;
                    break;
                }
            } else {
                keyGenerator.reset();
                size = keyGenerator.size();
            }
        }
        if ((valueMocker = property.findDecoratedBy(Mock.class)) == null && (a = property.findDecoratedBy(MAP.Value.class)) != null) {
            for (Annotation anno : a.annotationType().getAnnotations()) {
                if (anno.annotationType().getAnnotation(Mock.class) == null) continue;
                valueMocker = anno;
                break;
            }
        }
        if (keyGenerator != null || keyMocker != null || valueMocker != null) {
            return MockerFacade.mockMap(keyType, valueType, property, dimension, stack, map, context, size, keyMocker, valueMocker, keyGenerator);
        }
        return MockerFacade.getMapUseMAPAnnotation(keyType, valueType, property, dimension, stack, map, annotation, context);
    }

    private static <T extends Map> T getMapUseMAPAnnotation(Type keyType, Type valueType, PojoProperty property, int dimension, Stack<String> stack, Map map, MAP annotation, Type[] context) throws MaxDeepException {
        int size = 5;
        Annotation keyMocker = null;
        Annotation valueMocker = null;
        String keySeq = null;
        Sequence.NotFound notFound = Sequence.NotFound.WARN;
        if (annotation != null) {
            size = Math.max(1, annotation.size());
            keyMocker = (Annotation)property.getAnnotation(annotation.keyMocker());
            valueMocker = (Annotation)property.getAnnotation(annotation.valueMocker());
            if (keyType == null) {
                keyType = annotation.keyType();
            }
            if (valueType == null) {
                valueType = annotation.valueType();
            }
            keySeq = annotation.keySeq();
            notFound = annotation.notFound();
        }
        if (keyType == null) {
            keyType = String.class;
        }
        if (valueType == null) {
            valueType = String.class;
        }
        SequenceGenerator generator = null;
        if (!Common.isBlank(keySeq)) {
            generator = MockerFacade.getSequenceGenerator(keySeq, notFound, property);
        }
        if (generator != null) {
            generator.reset();
            size = generator.size();
        }
        return MockerFacade.mockMap((Type)keyType, (Type)valueType, property, dimension, stack, map, context, size, keyMocker, valueMocker, generator);
    }

    private static <T extends Map> T mockMap(Type keyType, Type valueType, PojoProperty property, int dimension, Stack<String> stack, Map map, Type[] context, int size, Annotation keyMocker, Annotation valueMocker, SequenceGenerator generator) throws MaxDeepException {
        int maxRetry = size * 10;
        int retryTimes = 0;
        while (map.size() < size && retryTimes++ < maxRetry) {
            final Annotation finalKeyMocker = keyMocker;
            Object key = generator == null ? MockerFacade.$mock(keyType, keyMocker == null ? null : new PojoProperty(property, keyType){

                @Override
                public Annotation[] getAnnotations() {
                    return new Annotation[]{finalKeyMocker};
                }
            }, dimension, stack, context) : generator.next();
            final Annotation finalValueMocker = valueMocker;
            T value = MockerFacade.$mock(valueType, valueMocker == null ? null : new PojoProperty(property, valueType){

                @Override
                public Annotation[] getAnnotations() {
                    return new Annotation[]{finalValueMocker};
                }
            }, dimension, stack, context);
            map.put(key, value);
        }
        return (T)map;
    }

    private static boolean isCollection(Type t) {
        if (t instanceof ParameterizedType) {
            return MockerFacade.isCollection(((ParameterizedType)t).getRawType());
        }
        if (t instanceof Class) {
            return ((Class)t).isArray() || Collection.class.isAssignableFrom((Class)t);
        }
        return t instanceof GenericArrayType;
    }

    private static <T extends Collection> T mockCollection(Class<? extends Collection> collectionClass, Type componentType, final PojoProperty property, final int dimension, final Stack<String> stack, final Type ... context) throws MaxDeepException {
        Collection<T> collection;
        if (List.class.equals(collectionClass)) {
            collection = new ArrayList();
        } else if (Set.class.equals(collectionClass)) {
            collection = new HashSet();
        } else {
            try {
                collection = collectionClass.newInstance();
            }
            catch (Throwable th) {
                throw new RuntimeException("unable init collection: " + th.getLocalizedMessage(), th);
            }
        }
        if (componentType == null) {
            componentType = Object.class;
        }
        final Type componetTypeRef = TypeHelper.toTypeReference((Type)componentType, context);
        int size = MockerFacade.getArraySize(property, dimension);
        if (MockerFacade.isCollection(componetTypeRef)) {
            for (int i = 0; i < size; ++i) {
                collection.add(MockerFacade.$mock(componetTypeRef, property, dimension + 1, stack, context));
            }
        } else {
            SequenceGenerator generator = MockerFacade.getGenerator(property);
            if (generator != null) {
                generator.reset();
                size = generator.size();
            }
            final Collection<T> finalCollection = collection;
            final int finalSize = size;
            SEQUENCE_CONTEXT.call(generator, new CallableClosure(){

                @Override
                public Object call() throws Throwable {
                    for (int i = 0; i < finalSize; ++i) {
                        finalCollection.add(MockerFacade.$mock(componetTypeRef, property, dimension + 1, stack, context));
                    }
                    return null;
                }
            });
        }
        return (T)collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T mockPojo(PojoInfo pojoInfo, PojoProperty property, Stack<String> stack, Type ... context) throws MaxDeepException {
        if (stack == null) {
            stack = new Stack();
        }
        stack.push(pojoInfo.getType().toString());
        try {
            int deep = MockerFacade.getDeep(property);
            String pojoType = pojoInfo.getType().toString();
            for (String s : stack) {
                if (!pojoType.equals(s) || --deep >= 0) continue;
                throw new MaxDeepException();
            }
            HashMap<String, List<String>> relations = new HashMap<String, List<String>>();
            for (PojoProperty pojoProperty : pojoInfo.getProperties()) {
                Relation relation = pojoProperty.getAnnotation(Relation.class);
                if (relations.containsKey(pojoProperty.getName()) || relation == null || relation.properties().length <= 0) continue;
                relations.put(pojoProperty.getName(), Arrays.asList(relation.properties()));
                List list = (List)relations.get(pojoProperty.getName());
                for (String dependency : list) {
                    if (pojoInfo.getProperty(dependency) != null) continue;
                    throw new RuntimeException("property not exists: " + dependency);
                }
                MockerFacade.checkCircular(relations, list, pojoProperty.getName());
            }
            Object object = MockerFacade.buildPojo(pojoInfo, stack, context);
            return (T)object;
        }
        finally {
            stack.pop();
        }
    }

    private static void checkCircular(Map<String, List<String>> relations, List<String> dependencies, String propertyName) {
        if (dependencies == null || dependencies.size() == 0) {
            return;
        }
        for (String s : dependencies) {
            if (propertyName.equals(s)) {
                throw new RuntimeException("circular relation: " + propertyName);
            }
            MockerFacade.checkCircular(relations, relations.get(s), propertyName);
        }
    }

    private static Object buildPojo(PojoInfo pojoInfo, Stack<String> stack, Type ... context) {
        Object instance;
        try {
            instance = POJO_BUILDER.newInstance(pojoInfo);
        }
        catch (Throwable th) {
            throw new RuntimeException("Cannot instance type: " + pojoInfo.getType().toString() + ", caused by: " + th.getLocalizedMessage(), th);
        }
        HashSet<String> over = new HashSet<String>();
        for (PojoProperty pojoProperty : pojoInfo.getProperties()) {
            try {
                MockerFacade.buildProperty(instance, over, stack, pojoInfo, pojoProperty, context);
            }
            catch (Throwable th) {
                String message = "Cannot set property: " + pojoProperty.getName() + ", caused by: " + th.getLocalizedMessage();
                if ("warn".equalsIgnoreCase(System.getProperty(Mock.POLICY_KEY))) {
                    log.warn("{}", (Object)message, (Object)th);
                    continue;
                }
                throw new RuntimeException(message, th);
            }
        }
        return instance;
    }

    private static void buildProperty(Object instance, Set<String> over, Stack<String> stack, PojoInfo pojoInfo, PojoProperty pojoProperty, Type[] context) throws Throwable {
        if (over.contains(pojoProperty.getName())) {
            return;
        }
        Relation relation = pojoProperty.getAnnotation(Relation.class);
        if (relation != null && relation.properties().length > 0) {
            ArrayList<Object> dependencies = new ArrayList<Object>();
            for (String property : relation.properties()) {
                PojoProperty p = pojoInfo.getProperty(property);
                MockerFacade.buildProperty(instance, over, stack, pojoInfo, p, context);
                dependencies.add(POJO_BUILDER.get(instance, p));
            }
            POJO_BUILDER.set(instance, pojoProperty, RELATION_POLICY_LOADER.select(relation.policy()).relate(relation.policy(), dependencies));
        } else {
            try {
                POJO_BUILDER.set(instance, pojoProperty, MockerFacade.$mock(pojoProperty.getType(), pojoProperty, 0, stack, context));
            }
            catch (MaxDeepException e) {
                POJO_BUILDER.set(instance, pojoProperty, null);
            }
        }
        over.add(pojoProperty.getName());
    }

    private static int getDeep(PojoProperty property) {
        Deep deep;
        int deepMin = 2;
        int deepMax = 5;
        if (property != null && (deep = property.getAnnotation(Deep.class)) != null) {
            deepMin = Math.max(1, deep.min());
            deepMax = Math.max(deep.max(), deepMin);
        }
        return Common.random(deepMin, deepMax);
    }

    private static int getArraySize(PojoProperty property, int dimension) {
        COLLECTION collectionAnnotation;
        int[] arraySize = COLLECTION.DEFAULT_SIZE;
        if (property != null && (collectionAnnotation = property.getAnnotation(COLLECTION.class)) != null) {
            arraySize = collectionAnnotation.size();
        }
        int size = -1;
        if (dimension < arraySize.length) {
            size = arraySize[dimension];
        } else if (arraySize.length > 0) {
            size = arraySize[arraySize.length - 1];
        }
        return size < 0 ? Common.random(1, 10) : size;
    }

    private static SequenceGenerator getSequenceGenerator(String key, Sequence.NotFound notFound, PojoProperty pojoProperty) {
        SequenceGenerator generator = (SequenceGenerator)SEQUENCE_CONTEXT.get(key);
        if (generator == null) {
            switch (notFound) {
                case WARN: {
                    log.warn("sequence [{}] not found. {}", (Object)key, (Object)pojoProperty);
                    break;
                }
                case ERROR: {
                    throw new RuntimeException("sequence [" + key + "] not found. " + pojoProperty);
                }
            }
        }
        return generator;
    }

    private static SequenceGenerator getGenerator(PojoProperty pojoProperty) {
        Sequence sequence;
        if (pojoProperty == null) {
            return null;
        }
        Sequence.Use use = pojoProperty.getAnnotation(Sequence.Use.class);
        SequenceGenerator generator = null;
        if (use != null) {
            generator = MockerFacade.getSequenceGenerator(use.key(), use.notFound(), pojoProperty);
        }
        if (generator == null && (sequence = pojoProperty.getAnnotation(Sequence.class)) != null) {
            generator = MockerFacade.buildSequenceGenerator(sequence);
        }
        return generator;
    }

    private static Annotation getAnnotationDecoratedBy(Annotation[] annotations, Class<? extends Annotation> decorater) {
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        for (Annotation a : annotations) {
            if (a.annotationType().getAnnotation(decorater) == null) continue;
            return a;
        }
        return null;
    }

    private static class MaxDeepException
    extends Exception {
        private MaxDeepException() {
        }
    }

    private static class SequenceContext
    extends AbstractKeyValueContext<SequenceGenerator> {
        private SequenceContext() {
        }

        @Override
        public Object call(SequenceGenerator generator, CallableClosure callableClosure) throws MaxDeepException {
            if (generator == null) {
                return MockerFacade.call(callableClosure);
            }
            return this.call(generator.getKey(), generator, callableClosure);
        }
    }

    private static class MockerRefContext
    extends AbstractKeyValueContext<Annotation> {
        private MockerRefContext() {
        }

        @Override
        public Object call(Annotation annotation, CallableClosure callableClosure) throws MaxDeepException {
            String name = MockerFacade.getMockerName(annotation);
            if (Common.isBlank(name)) {
                return MockerFacade.call(callableClosure);
            }
            return this.call(name, annotation, callableClosure);
        }
    }

    private static class AbstractKeyValueContext<V>
    extends MapClosureContext<String, V> {
        private AbstractKeyValueContext() {
        }

        @Override
        public Object call(String key, V v, CallableClosure callableClosure) throws MaxDeepException {
            try {
                return super.call(key, v, callableClosure);
            }
            catch (MaxDeepException mde) {
                throw mde;
            }
            catch (Throwable th) {
                throw Common.runtimeException(th);
            }
        }

        @Override
        public Object call(Map<String, V> map, CallableClosure callableClosure) throws MaxDeepException {
            try {
                return super.call(map, callableClosure);
            }
            catch (MaxDeepException mde) {
                throw mde;
            }
            catch (Throwable th) {
                throw Common.runtimeException(th);
            }
        }
    }
}

