/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.coodex.ssl.SSLContextFactory;
import org.coodex.util.Common;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertsSSLContextFactory
implements SSLContextFactory {
    private static final Logger log = LoggerFactory.getLogger(X509CertsSSLContextFactory.class);
    private static final String CERT_PATH = "certPath:".toLowerCase();
    private static final String CLASS_PATH = "classpath:";
    private static final String ALIAS = "concrete-certs-alias-";

    @Override
    public SSLContext getSSLContext(String param) throws Throwable {
        String certPath = Common.trim(param.substring(CERT_PATH.length()), ',', ' ', ':', ';');
        Set<String> allPath = Common.arrayToSet(Common.toArray(certPath, ";", new String[0]));
        SSLContext sslContext = SSLContext.getInstance("SSL");
        KeyStore trusted = KeyStore.getInstance(KeyStore.getDefaultType());
        trusted.load(null);
        int index = 1;
        for (String path : allPath) {
            if (Common.isBlank(path)) continue;
            if (path.toLowerCase().startsWith(CLASS_PATH)) {
                String[] certs;
                for (String cert : certs = Common.toArray(path.substring(CLASS_PATH.length()), ",", new String[0])) {
                    this.loadCertFromInputStream(trusted, this.getCertFromResource(cert), ALIAS + index++);
                }
                continue;
            }
            this.loadCertFromInputStream(trusted, this.getCertFromFile(path), ALIAS + index++);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trusted);
        sslContext.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
        return sslContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCertFromInputStream(KeyStore keyStore, InputStream inputStream, String alias) throws CertificateException, KeyStoreException, IOException {
        if (inputStream == null) {
            return;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            keyStore.setCertificateEntry(alias, certificateFactory.generateCertificate(inputStream));
        }
        finally {
            inputStream.close();
        }
    }

    private InputStream getCertFromResource(String path) throws IOException {
        if (Common.isBlank(path)) {
            return null;
        }
        URL url = Common.getResource(Common.trim(path, ' ', '/'), new ClassLoader[0]);
        if (url == null) {
            log.warn("cert resource not found: classpath:{}", (Object)path);
            return null;
        }
        return url.openStream();
    }

    private InputStream getCertFromFile(String path) throws IOException {
        if (Common.isBlank(path)) {
            return null;
        }
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            return new FileInputStream(file);
        }
        log.warn("cert file {} not exists.", (Object)path);
        return null;
    }

    @Override
    public boolean accept(String param) {
        return !Common.isBlank(param) && param.toLowerCase().startsWith(CERT_PATH);
    }
}

