/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.coodex.util.AcceptableService;
import org.coodex.util.GenericTypeHelper;
import org.coodex.util.ServiceLoader;
import org.coodex.util.ServiceLoaderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AcceptableServiceLoader<Param_Type, T extends AcceptableService<Param_Type>>
implements ServiceLoader<T> {
    private static final Logger log = LoggerFactory.getLogger(AcceptableServiceLoader.class);
    private ServiceLoader<T> serviceLoaderFacade;
    private T defaultService = null;

    public AcceptableServiceLoader() {
        this((AcceptableService)null);
    }

    public AcceptableServiceLoader(T defaultService) {
        this.defaultService = defaultService;
    }

    @Deprecated
    public AcceptableServiceLoader(ServiceLoader<T> serviceLoaderFacade) {
        this.serviceLoaderFacade = serviceLoaderFacade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceLoader<T> getServiceLoaderFacade() {
        if (this.serviceLoaderFacade == null) {
            AcceptableServiceLoader acceptableServiceLoader = this;
            synchronized (acceptableServiceLoader) {
                if (this.serviceLoaderFacade == null) {
                    this.serviceLoaderFacade = new ServiceLoaderImpl<T>(){

                        @Override
                        public T getDefault() {
                            return AcceptableServiceLoader.this.defaultService == null ? (AcceptableService)super.getDefault() : AcceptableServiceLoader.this.defaultService;
                        }
                    };
                }
            }
        }
        return this.serviceLoaderFacade;
    }

    private boolean accept(T instance, Param_Type param) {
        Class<?> paramClass;
        Class<?> clazz = paramClass = param == null ? null : param.getClass();
        if (paramClass == null) {
            return instance.accept(null);
        }
        Class required = GenericTypeHelper.typeToClass(GenericTypeHelper.solveFromInstance(AcceptableService.class.getTypeParameters()[0], instance));
        if (required != null && required.isAssignableFrom(paramClass)) {
            return instance.accept(param);
        }
        return false;
    }

    @Deprecated
    public List<T> getServiceInstances(Param_Type param) {
        return this.selectAll(param);
    }

    public List<T> selectAll(Param_Type param) {
        ArrayList<AcceptableService> list = new ArrayList<AcceptableService>();
        for (AcceptableService instance : this.getAll().values()) {
            if (!this.accept(instance, param)) continue;
            list.add(instance);
        }
        try {
            AcceptableService instance = (AcceptableService)this.getServiceLoaderFacade().getDefault();
            if (this.accept(instance, param)) {
                list.add(instance);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return list;
    }

    @Deprecated
    public T getServiceInstance(Param_Type param) {
        return this.select(param);
    }

    public T select(Param_Type param) {
        for (AcceptableService instance : this.getAll().values()) {
            if (!this.accept(instance, param)) continue;
            return (T)instance;
        }
        try {
            AcceptableService instance = (AcceptableService)this.getServiceLoaderFacade().getDefault();
            if (this.accept(instance, param)) {
                return (T)instance;
            }
            if (instance.accept(param)) {
                return (T)instance;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        log.info("no service instance accept this: {}", param);
        return null;
    }

    @Override
    @Deprecated
    public Collection<T> getAllInstances() {
        return this.getServiceLoaderFacade().getAll().values();
    }

    @Override
    public T get(Class<? extends T> providerClass) {
        return (T)((AcceptableService)this.getServiceLoaderFacade().get(providerClass));
    }

    @Override
    public T get(String name) {
        return (T)((AcceptableService)this.getServiceLoaderFacade().get(name));
    }

    @Override
    public T get() {
        return (T)((AcceptableService)this.getServiceLoaderFacade().get());
    }

    @Override
    public T getDefault() {
        return (T)((AcceptableService)this.getServiceLoaderFacade().getDefault());
    }

    @Override
    public Map<String, T> getAll() {
        return this.getServiceLoaderFacade().getAll();
    }

    @Override
    @Deprecated
    public Map<String, T> getInstances() {
        return this.getAll();
    }

    @Override
    @Deprecated
    public T getInstance(Class<? extends T> providerClass) {
        return (T)this.get((Class)providerClass);
    }

    @Override
    @Deprecated
    public T getInstance(String name) {
        return (T)this.get(name);
    }

    @Override
    @Deprecated
    public T getInstance() {
        return (T)this.get();
    }

    @Override
    @Deprecated
    public final T getDefaultProvider() {
        return (T)this.getDefault();
    }
}

