/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.coodex.config.Config;
import org.coodex.util.Common;
import org.coodex.util.ServiceLoaderImpl;
import org.coodex.util.Singleton;
import org.coodex.util.clock.ClockAgent;
import org.coodex.util.clock.DefaultClockAgent;
import org.coodex.util.clock.SystemClockAgent;

public final class Clock {
    public static final String KEY_MAGNIFICATION = Clock.class.getName() + ".magnification";
    private static Singleton<ClockAgent> agentSingleton = new Singleton<ClockAgent>(new Singleton.Builder<ClockAgent>(){

        @Override
        public ClockAgent build() {
            if (Clock.getMagnification().floatValue() == 1.0f) {
                return new SystemClockAgent();
            }
            return (ClockAgent)new ServiceLoaderImpl<ClockAgent>(){

                @Override
                public ClockAgent getDefault() {
                    return new DefaultClockAgent();
                }
            }.get();
        }
    });

    public static final Float getMagnification() {
        return Config.getValue(KEY_MAGNIFICATION, Common.to(System.getProperty(KEY_MAGNIFICATION), Float.valueOf(1.0f)), "clock");
    }

    public static long currentTimeMillis() {
        return agentSingleton.get().currentTimeMillis();
    }

    public static Calendar getCalendar() {
        return agentSingleton.get().getCalendar();
    }

    public static void sleep(long millis) throws InterruptedException {
        agentSingleton.get().sleep(millis);
    }

    public static void objWait(Object obj, long millis) throws InterruptedException {
        agentSingleton.get().objWait(obj, millis);
    }

    public static void sleep(TimeUnit timeUnit, long timeout) throws InterruptedException {
        agentSingleton.get().sleep(timeUnit, timeout);
    }

    public static long toMillis(long duration, TimeUnit timeUnit) {
        return agentSingleton.get().toMillis(duration, timeUnit);
    }
}

