/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.coodex.util.ClassNameFilter;
import org.coodex.util.Common;
import org.coodex.util.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectHelper {
    public static final ClassDecision NOT_NULL = new NotNullDecision();
    private static Logger log = LoggerFactory.getLogger(ReflectHelper.class);

    private ReflectHelper() {
    }

    public static String getParameterName(Object executable, int index, String prefix) {
        if (executable instanceof Method) {
            return ReflectHelper.getMethodParameterName((Method)executable, index, prefix);
        }
        if (executable instanceof Constructor) {
            return ReflectHelper.getConstructorParameterName((Constructor)executable, index, prefix);
        }
        throw new IllegalArgumentException("none Executable object: " + executable);
    }

    private static String getMethodParameterName(Method method, int index, String prefix) {
        String str = null;
        try {
            str = ReflectHelper.getParameterName(method, index);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Common.isBlank(str) ? prefix + index : str;
    }

    public static String getParameterName(Method method, int index) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        String s = ReflectHelper.getParameterNameByAnnotation(method.getParameterAnnotations(), index);
        return s == null ? ReflectHelper.getParameterNameByJava8(method, index) : s;
    }

    private static String getParameterNameByJava8(Method method, int index) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, ClassNotFoundException {
        return ReflectHelper.getExecutableParameterNameByJava8(method, index);
    }

    private static String getConstructorParameterName(Constructor constructor, int index, String prefix) {
        try {
            return ReflectHelper.getParameterName(constructor, index);
        }
        catch (Throwable th) {
            return prefix + index;
        }
    }

    private static String getParameterNameByAnnotation(Annotation[][] annotations, int index) {
        if (annotations == null || annotations.length < index) {
            return null;
        }
        for (Annotation annotation : annotations[index]) {
            if (!(annotation instanceof Parameter)) continue;
            return ((Parameter)annotation).value();
        }
        return null;
    }

    public static String getParameterName(Constructor constructor, int index) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        String s = ReflectHelper.getParameterNameByAnnotation(constructor.getParameterAnnotations(), index);
        return s == null ? ReflectHelper.getParameterNameByJava8(constructor, index) : s;
    }

    private static String getParameterNameByJava8(Constructor constructor, int index) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        return ReflectHelper.getExecutableParameterNameByJava8(constructor, index);
    }

    private static String getExecutableParameterNameByJava8(Object executable, int index) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        Method getParameters = Method.class.getMethod("getParameters", new Class[0]);
        Object[] parameters = (Object[])getParameters.invoke(executable, new Object[0]);
        if (parameters != null) {
            Class<?> methodParameterClass = Class.forName("java.lang.reflect.Parameter");
            Method getName = methodParameterClass.getMethod("getName", new Class[0]);
            return (String)getName.invoke(parameters[index], new Object[0]);
        }
        return null;
    }

    public static Field[] getAllDeclaredFields(Class<?> clz) {
        return ReflectHelper.getAllDeclaredFields(clz, null);
    }

    public static Field[] getAllDeclaredFields(Class<?> clz, ClassDecision decision) {
        if (clz == null) {
            throw new NullPointerException("class is NULL");
        }
        if (decision == null) {
            decision = NOT_NULL;
        }
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Class<?> clazz = clz;
        while (decision.determine(clazz)) {
            Field[] declaredFields = clazz.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                if (fields.containsKey(field.getName())) continue;
                fields.put(field.getName(), field);
            }
            clazz = clazz.getSuperclass();
        }
        return fields.values().toArray(new Field[0]);
    }

    public static Object invoke(Object obj, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (obj == null) {
            throw new NullPointerException("invoke target object is NULL.");
        }
        if (method.getDeclaringClass().isAssignableFrom(obj.getClass())) {
            return method.invoke(obj, args);
        }
        return obj.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke(obj, args);
    }

    private static String resourceToClassName(String resourceName) {
        if (resourceName.endsWith(".class")) {
            return resourceName.substring(0, resourceName.length() - 6).replace('/', '.');
        }
        return null;
    }

    private static String[] packageToPath(String[] packages) {
        if (packages == null || packages.length == 0) {
            return new String[0];
        }
        String[] paths = new String[packages.length];
        int i = 0;
        for (String p : packages) {
            paths[i++] = p == null ? "" : p.replace('.', '/');
        }
        return paths;
    }

    public static void foreachClass(final Processor processor, final ClassNameFilter filter, String ... packages) {
        if (processor == null) {
            return;
        }
        Common.forEach(new Common.Processor(){

            @Override
            public void process(URL resource, String resourceName) {
                String className = ReflectHelper.resourceToClassName(resourceName);
                try {
                    processor.process(Class.forName(className));
                }
                catch (ClassNotFoundException e) {
                    log.warn("load class fail. {}, {}", (Object)className, (Object)e.getLocalizedMessage());
                }
            }
        }, new Common.ResourceFilter(){

            @Override
            public boolean accept(String root, String resourceName) {
                String className = ReflectHelper.resourceToClassName(resourceName);
                return className != null && filter.accept(className);
            }
        }, ReflectHelper.packageToPath(packages));
    }

    public static <T> T throwExceptionObject(Class<T> interfaceClass, final Throwable th) {
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                throw th;
            }
        });
    }

    public static String typeToCodeStr(Type type) {
        StringBuilder builder = new StringBuilder();
        if (type instanceof ParameterizedType) {
            builder.append(ReflectHelper.typeToCodeStr(((ParameterizedType)type).getRawType())).append("<");
            int l = ((ParameterizedType)type).getActualTypeArguments().length;
            for (int i = 0; i < l; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(ReflectHelper.typeToCodeStr(((ParameterizedType)type).getActualTypeArguments()[i]));
            }
            builder.append(">");
        } else {
            if (type instanceof Class) {
                if (((Class)type).isArray()) {
                    return ReflectHelper.typeToCodeStr(((Class)type).getComponentType()) + "[]";
                }
                return ((Class)type).getName();
            }
            if (type instanceof TypeVariable) {
                return ((TypeVariable)type).getName();
            }
            if (type instanceof GenericArrayType) {
                return ReflectHelper.typeToCodeStr(((GenericArrayType)type).getGenericComponentType()) + "[]";
            }
        }
        return builder.toString();
    }

    private static Object invoke(Method method, Object first, Object[] objects, Object[] args) throws Throwable {
        if (first == null) {
            throw new NullPointerException();
        }
        if (method.getDeclaringClass().isAssignableFrom(first.getClass())) {
            return args == null || args.length == 0 ? method.invoke(first, new Object[0]) : method.invoke(first, args);
        }
        for (Object o : objects) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!method.getDeclaringClass().isAssignableFrom(o.getClass())) continue;
            return args == null || args.length == 0 ? method.invoke(o, new Object[0]) : method.invoke(o, args);
        }
        throw new RuntimeException("method not found in all objects: " + method.getName());
    }

    private static void addInterfaceTo(Class clz, Collection<Class> coll) {
        if (clz == null) {
            return;
        }
        if (coll.contains(clz)) {
            return;
        }
        if (clz.isInterface()) {
            coll.add(clz);
        }
        ReflectHelper.addInterfaceTo(clz.getSuperclass(), coll);
        for (Class<?> c : clz.getInterfaces()) {
            ReflectHelper.addInterfaceTo(c, coll);
        }
    }

    @Deprecated
    public static <T> T extend(T o, Object ... objects) {
        return (T)ReflectHelper.extendInterface(o, objects);
    }

    public static <S, T extends S> S extendInterface(final T o, final Object ... objects) {
        if (o == null) {
            return null;
        }
        if (objects == null || objects.length == 0) {
            return o;
        }
        HashSet<Class> interfaces = new HashSet<Class>();
        ReflectHelper.addInterfaceTo(o.getClass(), interfaces);
        for (Object x : objects) {
            if (x == null) continue;
            ReflectHelper.addInterfaceTo(x.getClass(), interfaces);
        }
        if (interfaces.size() == 0) {
            return o;
        }
        return (S)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces.toArray(new Class[0]), new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return ReflectHelper.invoke(method, o, objects, args);
            }
        });
    }

    private static class AllObjectExceptJavaSDK
    implements ClassDecision {
        private AllObjectExceptJavaSDK() {
        }

        @Override
        public boolean determine(Class<?> clz) {
            return clz != null && !clz.getPackage().getName().startsWith("java");
        }
    }

    private static class AllObjectDecision
    implements ClassDecision {
        private AllObjectDecision() {
        }

        @Override
        public boolean determine(Class<?> clz) {
            return clz != null && clz != Object.class;
        }
    }

    private static class NotNullDecision
    implements ClassDecision {
        private NotNullDecision() {
        }

        @Override
        public boolean determine(Class<?> clz) {
            return clz != null;
        }
    }

    public static class MethodParameter {
        private final Method method;
        private final int index;
        private String name;
        private Annotation[] annotations;
        private Class<?> type;
        private Type genericType;

        public MethodParameter(Method method, int index) {
            this.method = method;
            this.index = index;
            this.annotations = method.getParameterAnnotations()[index];
            this.type = method.getParameterTypes()[index];
            this.genericType = method.getGenericParameterTypes()[index];
            this.name = ReflectHelper.getParameterName(method, index, "p");
        }

        public Class<?> getType() {
            return this.type;
        }

        public Type getGenericType() {
            return this.genericType;
        }

        public Method getMethod() {
            return this.method;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public Annotation[] getAnnotations() {
            return this.annotations;
        }

        public <T> T getAnnotation(Class<T> annotationClass) {
            if (annotationClass == null) {
                throw new IllegalArgumentException("annotationClass is NULL.");
            }
            if (this.annotations == null) {
                return null;
            }
            for (Annotation annotation : this.annotations) {
                if (!annotationClass.isAssignableFrom(annotation.getClass())) continue;
                return (T)annotation;
            }
            return null;
        }
    }

    public static interface ClassDecision {
        public boolean determine(Class<?> var1);
    }

    public static interface Processor {
        public void process(Class<?> var1);
    }
}

