/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.Calendar;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.coodex.concurrent.ExecutorsHelper;
import org.coodex.util.Clock;
import org.coodex.util.NameSupplier;
import org.coodex.util.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retry {
    private static final Logger log = LoggerFactory.getLogger(Retry.class);
    private static final Integer DEFAULT_MAX_TIMES = 5;
    private static final NextDelay DEFAULT_NEXT_DELAY = new TimeUnitNextDelay(TimeUnit.SECONDS){

        @Override
        protected long delay(int times) {
            return 5L;
        }
    };
    private static final Singleton<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_SINGLETON = new Singleton<ScheduledExecutorService>(new Singleton.Builder<ScheduledExecutorService>(){

        @Override
        public ScheduledExecutorService build() {
            return ExecutorsHelper.newScheduledThreadPool(Runtime.getRuntime().availableProcessors() * 2, "retry");
        }
    });
    private ScheduledExecutorService scheduledExecutorService;
    private Integer maxTimes;
    private long initDelay = 0L;
    private NextDelay nextDelay;
    private NameSupplier taskNameSupplier = null;
    private OnFailed onFailed = null;
    private AllFailedHandle allFailedHandle = null;
    private int num = 1;
    private Status status = Status.INIT;
    private Task task;
    private Calendar start;

    private Retry() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void execute(final Runnable runnable) {
        this.execute(new Task(){

            @Override
            public boolean run(int times) throws Exception {
                runnable.run();
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Task task) {
        if (task == null) {
            throw new NullPointerException("task is null.");
        }
        Retry retry = this;
        synchronized (retry) {
            if (!Status.INIT.equals((Object)this.status)) {
                throw new IllegalStateException("task has scheduled.");
            }
            this.task = task;
            this.status = Status.WAITING;
        }
        this.postTask();
    }

    public void execute() {
        this.execute(this.task);
    }

    private String getTaskName() {
        return this.taskNameSupplier == null ? this.task.toString() : this.taskNameSupplier.getName();
    }

    private void postTask() {
        this.scheduledExecutorService.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Retry retry = Retry.this;
                synchronized (retry) {
                    if (Status.FINISHED.equals((Object)Retry.this.status)) {
                        return;
                    }
                    Retry.this.status = Status.RUNNING;
                    if (Retry.this.start == null) {
                        Retry.this.start = Clock.getCalendar();
                    }
                    Calendar thisTimes = Clock.getCalendar();
                    int times = Retry.this.num;
                    Throwable throwable = null;
                    boolean success = false;
                    try {
                        success = Retry.this.task.run(times);
                    }
                    catch (Throwable th) {
                        throwable = th;
                    }
                    finally {
                        Retry.this.num++;
                    }
                    if (success || Retry.this.num > Retry.this.maxTimes) {
                        Retry.this.status = Status.FINISHED;
                        if (success) {
                            if (log.isDebugEnabled()) {
                                log.debug("{} success. [{}]", (Object)Retry.this.getTaskName(), (Object)times);
                            }
                        } else {
                            if (log.isInfoEnabled()) {
                                log.info("{} all failed.", (Object)Retry.this.getTaskName());
                            }
                            Retry.this.onFailed(thisTimes, times, throwable);
                            if (Retry.this.allFailedHandle != null) {
                                try {
                                    Retry.this.allFailedHandle.allFailed(Retry.this.start, times);
                                }
                                catch (Throwable t) {
                                    log.warn("handle error.", t);
                                }
                            }
                        }
                    } else {
                        Retry.this.onFailed(thisTimes, times, throwable);
                        if (throwable != null && log.isWarnEnabled()) {
                            log.warn("{} failed [{}] times. {}", new Object[]{Retry.this.getTaskName(), times, throwable.getLocalizedMessage(), throwable});
                        }
                        if (throwable == null && log.isInfoEnabled()) {
                            log.info("{} failed [{}] times.", (Object)Retry.this.getTaskName(), (Object)times);
                        }
                        Retry.this.status = Status.WAITING;
                        Retry.this.postTask();
                    }
                }
            }
        }, this.num == 1 ? this.initDelay : this.nextDelay.next(this.num), TimeUnit.MILLISECONDS);
    }

    public void onFailed(Calendar start, int times, Throwable throwable) {
        if (this.onFailed != null) {
            try {
                this.onFailed.onFailed(start, times, throwable);
            }
            catch (Throwable t) {
                log.warn("on failed handle error.", t);
            }
        }
    }

    public Status getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Retry handle(AllFailedHandle allFailedHandle) {
        Retry retry = this;
        synchronized (retry) {
            if (this.status.status >= Status.RUNNING.getStatus()) {
                throw new IllegalStateException();
            }
            this.allFailedHandle = allFailedHandle;
        }
        return this;
    }

    public static class Builder {
        private ScheduledExecutorService scheduledExecutorService;
        private Integer maxTimes;
        private long initDelay = 0L;
        private NextDelay nextDelay;
        private NameSupplier taskNameSupplier = null;
        private OnFailed onFailed = null;
        private AllFailedHandle allFailedHandle = null;

        private Builder() {
        }

        public Builder scheduler(ScheduledExecutorService scheduledExecutorService) {
            this.scheduledExecutorService = scheduledExecutorService;
            return this;
        }

        public Builder maxTimes(int maxRetryTimes) {
            if (maxRetryTimes < 1) {
                throw new IllegalArgumentException("illegal maxRetryTimes: " + maxRetryTimes);
            }
            this.maxTimes = maxRetryTimes;
            return this;
        }

        public Builder initDelay(long initDelay, TimeUnit unit) {
            this.initDelay = unit.toMillis(initDelay);
            return this;
        }

        public Builder next(NextDelay nextDelay) {
            this.nextDelay = nextDelay;
            return this;
        }

        public Builder named(final String name) {
            this.taskNameSupplier = new NameSupplier(){

                @Override
                public String getName() {
                    return name;
                }
            };
            return this;
        }

        public Builder named(NameSupplier taskNameSupplier) {
            this.taskNameSupplier = taskNameSupplier;
            return this;
        }

        public Builder onFailed(OnFailed onFailed) {
            this.onFailed = onFailed;
            return this;
        }

        public Builder onAllFailed(AllFailedHandle allFailedHandle) {
            this.allFailedHandle = allFailedHandle;
            return this;
        }

        public Retry build() {
            Retry retry = new Retry();
            retry.initDelay = this.initDelay;
            retry.maxTimes = this.maxTimes == null ? DEFAULT_MAX_TIMES : this.maxTimes;
            retry.nextDelay = this.nextDelay == null ? DEFAULT_NEXT_DELAY : this.nextDelay;
            retry.scheduledExecutorService = this.scheduledExecutorService == null ? (ScheduledExecutorService)SCHEDULED_EXECUTOR_SERVICE_SINGLETON.get() : this.scheduledExecutorService;
            retry.taskNameSupplier = this.taskNameSupplier;
            retry.onFailed = this.onFailed;
            retry.allFailedHandle = this.allFailedHandle;
            return retry;
        }
    }

    public static abstract class TimeUnitNextDelay
    implements NextDelay {
        private final TimeUnit unit;

        protected TimeUnitNextDelay(TimeUnit unit) {
            this.unit = unit;
        }

        protected abstract long delay(int var1);

        @Override
        public long next(int times) {
            return this.unit.toMillis(this.delay(times));
        }
    }

    public static interface NextDelay {
        public long next(int var1);
    }

    public static interface Task {
        public boolean run(int var1) throws Exception;
    }

    public static interface OnFailed {
        public void onFailed(Calendar var1, int var2, Throwable var3);
    }

    @Deprecated
    public static interface TaskNameSupplier
    extends NameSupplier {
    }

    public static interface AllFailedHandle {
        public void allFailed(Calendar var1, int var2);
    }

    public static enum Status {
        INIT(0),
        WAITING(1),
        RUNNING(2),
        FINISHED(3);

        private int status;

        private Status(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

