/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.coodex.closure.CallableClosure;
import org.coodex.closure.StackClosureContext;
import org.coodex.util.Clock;
import org.coodex.util.Common;
import org.coodex.util.NameSupplier;
import org.coodex.util.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tracer {
    private static final Logger log = LoggerFactory.getLogger(Tracer.class);
    private static final StackClosureContext<Map<String, Object>> tracer_context = new StackClosureContext();
    private static Singleton<Boolean> TRACE_ENABLED = new Singleton<Boolean>(new Singleton.Builder<Boolean>(){

        @Override
        public Boolean build() {
            return Common.toBool(System.getProperty("org.coodex.util.Tracer"), false);
        }
    });
    private static String START_TIME_KEY = Common.getUUIDStr();
    private Logger logger = log;
    private NameSupplier nameSupplier = null;

    private Tracer() {
    }

    public static void putTrace(String key, Object value) {
        if (Tracer.isEnabled() && tracer_context.get() != null) {
            tracer_context.get().put(key, value);
        }
    }

    public static void start(String label) {
        if (Tracer.isEnabled() && tracer_context.get() != null) {
            Tracer.getStartTimeMap().put(label, Clock.currentTimeMillis());
        }
    }

    private static Map<String, Long> getStartTimeMap() {
        return (Map)tracer_context.get().get(START_TIME_KEY);
    }

    public static void end(String label) {
        if (Tracer.isEnabled() && tracer_context.get() != null && Tracer.getStartTimeMap().containsKey(label)) {
            long used = Clock.currentTimeMillis() - Tracer.getStartTimeMap().get(label);
            Tracer.getStartTimeMap().remove(label);
            Tracer.putTrace(label, "used " + used + " ms");
        }
    }

    public static Tracer newTracer() {
        return new Tracer();
    }

    private static boolean isEnabled() {
        return TRACE_ENABLED.get();
    }

    public Tracer logger(Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger is null.");
        }
        this.logger = logger;
        return this;
    }

    public Tracer logger(String loggerName) {
        this.logger = LoggerFactory.getLogger((String)loggerName);
        return this;
    }

    public Tracer logger(Class<?> clz) {
        this.logger = LoggerFactory.getLogger(clz);
        return this;
    }

    public Tracer named(final String name) {
        this.nameSupplier = Common.isBlank(name) ? null : new NameSupplier(){

            @Override
            public String getName() {
                return name;
            }
        };
        return this;
    }

    public Tracer named(NameSupplier nameSupplier) {
        this.nameSupplier = nameSupplier;
        return this;
    }

    public void trace(final Runnable runnable) {
        if (Tracer.isEnabled()) {
            this.trace(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    runnable.run();
                    return null;
                }
            });
        } else {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T trace(final Callable<T> callable) {
        if (Tracer.isEnabled()) {
            long start = Clock.currentTimeMillis();
            Throwable throwable = null;
            LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>();
            try {
                context.put(START_TIME_KEY, new HashMap());
                Object object = tracer_context.call((Map<String, Object>)context, new CallableClosure(){

                    @Override
                    public Object call() throws Throwable {
                        return callable.call();
                    }
                });
                return (T)object;
            }
            catch (Throwable th) {
                throwable = th;
            }
            finally {
                long used = Clock.currentTimeMillis() - start;
                if (throwable != null && this.logger.isErrorEnabled()) {
                    String info = this.buildTraceInfo(context);
                    log.error(info + "used {} ms.", (Object)used, (Object)throwable);
                } else if (throwable == null && this.logger.isInfoEnabled()) {
                    String info = this.buildTraceInfo(context);
                    log.info(info + "used {} ms.", (Object)used);
                }
            }
            throw Common.runtimeException(throwable);
        }
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw Common.runtimeException(e);
        }
    }

    private String buildTraceInfo(Map<String, Object> context) {
        StringBuilder builder = new StringBuilder();
        if (this.nameSupplier != null) {
            builder.append("TRACER ").append(this.nameSupplier.getName()).append(": [");
        } else {
            builder.append("[");
        }
        boolean first = true;
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            if (START_TIME_KEY.equals(entry.getKey())) continue;
            if (!first) {
                builder.append("; ");
            }
            builder.append(entry.getKey()).append(": ").append(entry.getValue() == null ? null : entry.getValue().toString());
            first = false;
        }
        builder.append("] ");
        return builder.toString();
    }
}

