/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util.clock;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import org.coodex.util.clock.DefaultClockAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClockAgentService
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ClockAgentService.class);
    public static int PORT = 8360;
    private final int port;
    private final String host;
    private boolean listening = false;
    private DefaultClockAgent defaultClockAgent = new DefaultClockAgent();

    public ClockAgentService() {
        this("0.0.0.0", PORT);
    }

    public ClockAgentService(String host, int port) {
        this.port = port;
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            serverSocketChannel = ServerSocketChannel.open();
            try {
                serverSocketChannel.configureBlocking(false);
                serverSocketChannel.socket().bind(new InetSocketAddress(this.host, this.port));
                ClockAgentService.log.info("Clock Agent Service start [{}:{}]....", (Object)this.host, (Object)this.port);
                this.listening = true;
                selector = Selector.open();
                serverSocketChannel.register(selector, 16);
                block5: while (true) {
                    if (!this.listening) {
                        break;
                    }
                    if (selector.select(3000L) == 0) continue;
                    keyIterator = selector.selectedKeys().iterator();
                    while (true) {
                        if (keyIterator.hasNext()) ** break;
                        continue block5;
                        key = keyIterator.next();
                        if (key.isAcceptable()) {
                            socketChannel = ((ServerSocketChannel)key.channel()).accept();
                            socketChannel.configureBlocking(false);
                            buffer = ByteBuffer.allocate(20);
                            buffer.putLong(0, this.defaultClockAgent.getStart());
                            buffer.putLong(8, this.defaultClockAgent.getBaseLine());
                            buffer.putFloat(16, this.defaultClockAgent.getMagnification().floatValue());
                            socketChannel.write(buffer);
                        }
                        keyIterator.remove();
                    }
                    break;
                }
            }
            finally {
                serverSocketChannel.close();
                ClockAgentService.log.debug("Clock Agent Service shutdown.");
            }
        }
        catch (IOException e) {
            ClockAgentService.log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void shutdown() {
        this.listening = false;
    }
}

