/*
 * Copyright (c) 2019 coodex.org (jujus.shen@126.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.coodex.util;

import java.util.HashMap;
import java.util.Map;

public class JavaUtilServiceLoaderProvider implements ServiceLoaderProvider {
    @Override
    public <S> Map<String, S> load(Class<S> serviceClass) {
        Map<String, S> map = new HashMap<String, S>();
        for (S service : java.util.ServiceLoader.load(serviceClass)) {
            map.put(service.getClass().getName(), service);
        }
        return map;
    }
}
