/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.coodex.concurrent.AbstractCoalition;
import org.coodex.concurrent.Coalition;

public class Debouncer<T>
extends AbstractCoalition<T> {
    private ScheduledFuture prevFuture = null;

    public Debouncer(Coalition.Callback<T> c, int interval, ScheduledExecutorService scheduledExecutorService) {
        super(c, interval, scheduledExecutorService);
    }

    public Debouncer(Coalition.Callback<T> c, int interval) {
        super(c, interval);
    }

    @Override
    public synchronized void call(final T key) {
        if (this.prevFuture != null) {
            this.prevFuture.cancel(true);
        }
        this.prevFuture = this.scheduledExecutorService.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Debouncer debouncer = Debouncer.this;
                synchronized (debouncer) {
                    Debouncer.this.callback.call(key);
                    Debouncer.this.prevFuture = null;
                }
            }
        }, (long)this.interval, TimeUnit.MILLISECONDS);
    }
}

