/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.config;

import java.util.List;
import java.util.Properties;
import org.coodex.config.AbstractConfiguration;
import org.coodex.config.Configuration;
import org.coodex.config.ConfigurationBaseProfile;
import org.coodex.config.DefaultConfigurationProvider;
import org.coodex.util.Common;
import org.coodex.util.LazyServiceLoader;
import org.coodex.util.Singleton;

public class Config {
    public static final AbstractConfiguration BASE_SYSTEM_PROPERTIES = new AbstractConfiguration(){

        @Override
        protected String search(String namespace, List<String> keys) {
            Properties properties = System.getProperties();
            for (String key : keys) {
                if (!properties.containsKey(key)) continue;
                return System.getProperty(key);
            }
            return null;
        }
    };
    private static LazyServiceLoader<DefaultConfigurationProvider> configurationProviderLazyServiceLoader = new LazyServiceLoader<DefaultConfigurationProvider>(new DefaultConfigurationProvider(){

        @Override
        public Configuration get() {
            return new ConfigurationBaseProfile();
        }
    }){};
    private static LazyServiceLoader<Configuration> configurationServiceLoader = new LazyServiceLoader<Configuration>((Singleton.Builder)new Singleton.Builder<Configuration>(){

        @Override
        public Configuration build() {
            return ((DefaultConfigurationProvider)configurationProviderLazyServiceLoader.get()).get();
        }
    }){};

    public static Configuration getConfig() {
        return configurationServiceLoader.get();
    }

    public static String get(String key, String ... namespaces) {
        String v = Config.getConfig().get(key, namespaces);
        return v == null ? BASE_SYSTEM_PROPERTIES.get(key, namespaces) : v;
    }

    public static <T> T getValue(final String key, final T defaultValue, final String ... namespace) {
        return Config.getConfig().getValue(key, new Common.Supplier<T>(){

            @Override
            public T get() {
                return BASE_SYSTEM_PROPERTIES.getValue(key, defaultValue, namespace);
            }
        }, namespace);
    }

    public static <T> T getValue(final String key, final Common.Supplier<T> defaultValueSupplier, final String ... namespace) {
        return Config.getConfig().getValue(key, new Common.Supplier<T>(){

            @Override
            public T get() {
                return BASE_SYSTEM_PROPERTIES.getValue(key, defaultValueSupplier, namespace);
            }
        }, namespace);
    }

    public static String[] getArray(String key, String ... namespaces) {
        return Common.toArray(Config.get(key, namespaces), ",", (String[])null);
    }

    public static String[] getArray(String key, String delim, String[] defaultValue, String ... namespaces) {
        return Common.toArray(Config.get(key, namespaces), delim, defaultValue);
    }

    public static String[] getArray(String key, String delim, Common.Supplier<String[]> supplier, String ... namespaces) {
        return Common.toArray(Config.get(key, namespaces), delim, supplier);
    }
}

