/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.pojomocker.sequence;

import java.text.ParseException;
import java.util.Calendar;
import org.coodex.pojomocker.sequence.AbstractConfigurableSequenceGenerator;
import org.coodex.util.Clock;
import org.coodex.util.Common;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class DateTimeSequence<T>
extends AbstractConfigurableSequenceGenerator<T> {
    private static final Logger log = LoggerFactory.getLogger(DateTimeSequence.class);
    private int size;
    private int index;
    private Calendar start;
    private int unit;
    private int interval;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void reset() {
        this.size = this.getConfig().getValue("size", 20, new String[0]);
        this.index = 0;
        this.start = null;
        String startTimeStr = this.getConfig().get("startTime", new String[0]);
        if (!Common.isBlank(startTimeStr)) {
            String startTimeFormat = this.getConfig().get("format", new String[0]);
            String parseFormat = Common.isBlank(startTimeFormat) ? "yyyy-MM-dd HH:mm:ss" : startTimeFormat;
            try {
                this.start = Common.strToCalendar(startTimeStr, parseFormat);
            }
            catch (ParseException e) {
                if (Common.isBlank(startTimeFormat)) {
                    log.warn("no [for] for time {}", (Object)startTimeStr);
                }
                log.warn("time {} format {} mismatch.", (Object)startTimeFormat, (Object)startTimeStr);
            }
        }
        if (this.start == null) {
            this.start = Clock.now();
        }
        String inteval = this.getConfig().getValue("interval", "1h", new String[0]);
        this.parseInterval(inteval);
    }

    private void parseInterval(String inteval) {
        char[] seq = inteval.toLowerCase().toCharArray();
        StringBuilder number = new StringBuilder();
        StringBuilder unitBuilder = new StringBuilder();
        boolean isNumber = true;
        for (char ch : seq) {
            if (isNumber) {
                if (ch == '-' || ch >= '0' && ch <= '9') {
                    number.append(ch);
                } else {
                    isNumber = false;
                }
            }
            if (isNumber || ch == ' ' && unitBuilder.length() == 0) continue;
            unitBuilder.append(ch);
        }
        this.interval = Integer.parseInt(number.toString());
        String unitStr = unitBuilder.toString();
        if ("y".equals(unitStr) || "year".equals(unitStr)) {
            this.unit = 1;
        } else if ("month".equals(unitStr)) {
            this.unit = 2;
        } else if ("d".equals(unitStr) || "day".equals(unitStr) || "days".equals(unitStr)) {
            this.unit = 5;
        } else if ("h".equals(unitStr) || "hour".equals(unitStr) || "hours".equals(unitStr)) {
            this.unit = 10;
        } else if ("m".equals(unitStr) || "min".equals(unitStr)) {
            this.unit = 12;
        } else if ("s".equals(unitStr) || "sec".equals(unitStr)) {
            this.unit = 13;
        } else if ("ms".equals(unitStr)) {
            this.unit = 14;
        } else {
            throw new RuntimeException("invalid interval setting: " + inteval);
        }
    }

    protected Calendar getNext() {
        Calendar calendar = (Calendar)this.start.clone();
        calendar.add(this.unit, this.interval * this.index++);
        return calendar;
    }

    protected abstract T copy(Calendar var1);

    @Override
    public T next() {
        return this.copy(this.getNext());
    }
}

