/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.coodex.util.Clock;
import org.coodex.util.DigestHelper;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.SingletonMap;
import org.coodex.util.StringConvertWithDefaultValue;
import org.coodex.util.UUIDHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Common {
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Logger log = LoggerFactory.getLogger(Common.class);
    private static final int TO_LOWER = 32;
    private static final String DEFAULT_DELIM = ".-_ /\\";
    private static ThreadLocal<SingletonMap<String, DateFormat>> threadLocal = new ThreadLocal();
    private static LazySelectableServiceLoader<Class<?>, StringConvertWithDefaultValue> converterServiceLoader = new LazySelectableServiceLoader<Class<?>, StringConvertWithDefaultValue>(){};

    private Common() {
    }

    private static String pathRoot(String pattern) {
        StringBuilder builder = new StringBuilder();
        StringBuilder node = new StringBuilder();
        for (char ch : pattern.toCharArray()) {
            if (ch == '*') break;
            if (ch == '/') {
                builder.append((CharSequence)node).append(ch);
                node = new StringBuilder();
                continue;
            }
            node.append(ch);
        }
        if (node.length() > 0) {
            builder.append((CharSequence)node);
        }
        return Common.trim(builder.toString(), new char[0]);
    }

    private static Set<PathPattern> toPathPatterns(String[] paths) {
        LinkedHashSet<PathPattern> pathPatterns = new LinkedHashSet<PathPattern>();
        if (paths != null && paths.length > 0) {
            for (String path : paths) {
                pathPatterns.add(new PathPattern(Common.trim(path, new char[0]) + "/"));
            }
        }
        return pathPatterns;
    }

    private static Collection<String> merge(Collection<PathPattern> pathPatterns) {
        ArrayList<String> list = new ArrayList<String>();
        for (PathPattern pathPattern : pathPatterns) {
            list.add(pathPattern.path);
        }
        String[] toMerge = list.toArray(new String[0]);
        list.clear();
        Arrays.sort(toMerge, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.length() - o2.length();
            }
        });
        for (String s : toMerge) {
            boolean exits = false;
            for (String x : list) {
                if (!s.startsWith(x)) continue;
                exits = true;
                break;
            }
            if (exits) continue;
            list.add(s);
        }
        return list;
    }

    public static void forEach(Processor processor, final ResourceFilter filter, String ... paths) {
        try {
            final Set<PathPattern> pathPatterns = Common.toPathPatterns(paths);
            ResourceFilter resourceFilter = new ResourceFilter(){

                @Override
                public boolean accept(String root, String resourceName) {
                    boolean pathOk = false;
                    for (PathPattern pathPattern : pathPatterns) {
                        if (!pathPattern.pattern.matcher(resourceName).matches()) continue;
                        pathOk = true;
                        break;
                    }
                    return pathOk && filter.accept(root, resourceName);
                }
            };
            for (String path : Common.merge(pathPatterns)) {
                path = Common.trim(path, '/');
                Enumeration<URL> resourceRoots = Common.class.getClassLoader().getResources(path);
                while (resourceRoots.hasMoreElements()) {
                    URL url = resourceRoots.nextElement();
                    String urlStr = url.toString();
                    int indexOfZipMarker = urlStr.indexOf(33);
                    String resourceRoot = urlStr.substring(0, urlStr.length() - path.length() - 1);
                    if (indexOfZipMarker > 0) {
                        File f = new File(new URI(url.getFile()));
                        String fileName = f.getAbsolutePath();
                        Common.forEachInZip(resourceRoot, path, processor, resourceFilter, new File(fileName.substring(0, fileName.length() - 2 - path.length())));
                        continue;
                    }
                    Common.forEachInDir(resourceRoot, path.replace('\\', '/'), processor, resourceFilter, new File(url.toURI()), true);
                }
            }
        }
        catch (IOException e) {
            log.warn("resource search failed. {}.", (Object)e.getLocalizedMessage(), (Object)e);
        }
        catch (URISyntaxException e) {
            log.warn("resource search failed. {}.", (Object)e.getLocalizedMessage(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forEachInZip(String root, String path, Processor processor, ResourceFilter filter, File zipFile) throws IOException {
        ZipFile zip = new ZipFile(zipFile);
        log.debug("Scan items in [{}]:{{}}", (Object)zipFile.getAbsolutePath(), (Object)path);
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                String entryName;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(entryName = entry.getName()).startsWith(path) || !filter.accept(root, entryName)) continue;
                processor.process(new URL(root + "/" + entryName), entryName);
            }
        }
        finally {
            zip.close();
        }
    }

    private static void forEachInDir(String root, String path, Processor processor, ResourceFilter filter, File dir, boolean header) throws MalformedURLException {
        if (header) {
            log.debug("Scan items in dir[{}]:[{}]", (Object)dir.getAbsolutePath(), (Object)path);
        }
        for (File f : dir.listFiles()) {
            String resourceName = path + '/' + f.getName();
            if (f.isDirectory()) {
                Common.forEachInDir(root, resourceName, processor, filter, f, false);
                continue;
            }
            if (!filter.accept(root, resourceName)) continue;
            processor.process(new URL(root + '/' + resourceName), resourceName);
        }
    }

    public static <T> Set<T> arrayToSet(T[] array) {
        return new HashSet<T>(Arrays.asList(array));
    }

    public static String getUUIDStr() {
        return UUIDHelper.getUUIDString();
    }

    public static String sha1(String content) {
        byte[] buf = content == null ? new byte[]{} : content.getBytes();
        return DigestHelper.sha1(buf);
    }

    public static <T> boolean inArray(T el, T[] array) {
        return Common.findInArray(el, array) >= 0;
    }

    public static <T> int findInArray(T el, T[] array) {
        for (int i = 0; i < array.length; ++i) {
            T t = array[i];
            if (el != t && (t == null || !t.equals(el))) continue;
            return i;
        }
        return -1;
    }

    public static String nullToStr(String str) {
        return str == null ? "" : str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        try {
            oos.writeObject(object);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            oos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(byte[] buf) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        ObjectInputStream ois = new ObjectInputStream(bis);
        try {
            Object object = ois.readObject();
            return object;
        }
        finally {
            ois.close();
        }
    }

    public static <T extends Serializable> T deepCopy(T object) throws IOException, ClassNotFoundException {
        return (T)((Serializable)Common.deserialize(Common.serialize(object)));
    }

    public static int random(int max) {
        return Common.random(0, max);
    }

    public static int random(int min, int max) {
        return (int)Common.random((long)min, (long)max);
    }

    public static long random(long min, long max) {
        if (min == max) {
            return min;
        }
        float _min = Math.min(min, max);
        float _max = Math.max(min, max);
        return (long)((double)_min + Math.random() * (double)(_max - _min));
    }

    public static double random(double min, double max) {
        if (min == max) {
            return min;
        }
        double _min = Math.min(min, max);
        double _max = Math.max(min, max);
        return _min + Math.random() * (_max - _min);
    }

    public static <K extends Serializable, V extends Serializable> void copyMap(Map<K, V> org, Map<K, V> target) {
        for (Serializable key : org.keySet()) {
            try {
                target.put(Common.deepCopy(key), Common.deepCopy((Serializable)org.get(key)));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        Common.copyStream(is, os, 4096, false, Integer.MAX_VALUE);
    }

    public static void copyStream(InputStream is, OutputStream os, int blockSize, boolean flushPerBlock, int bps) throws IOException {
        int cached;
        byte[] buf = new byte[blockSize];
        long start = Clock.currentTimeMillis();
        long wrote = 0L;
        while ((cached = is.read(buf)) > 0) {
            if (wrote >= (long)bps) {
                long n = wrote / (long)bps;
                wrote %= (long)bps;
                long interval = Clock.currentTimeMillis() - start;
                try {
                    if (interval < 1000L * n) {
                        Clock.sleep(interval);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            start = Clock.currentTimeMillis();
            os.write(buf, 0, cached);
            if (!flushPerBlock) continue;
            os.flush();
            wrote += (long)cached;
        }
        if (!flushPerBlock) {
            os.flush();
        }
    }

    public static void checkNull(Object o, String msg) {
        if (o == null) {
            throw new NullPointerException(msg);
        }
    }

    private static <T extends Comparable<T>> T _max(T c1, T c2) {
        return c1.compareTo(c2) >= 0 ? c1 : c2;
    }

    public static <T extends Comparable<T>> boolean between(T t, T bound1, T bound2) {
        Common.checkNull(t, "t is null");
        Common.checkNull(bound1, "bound1 is null");
        Common.checkNull(bound2, "bound2 is null");
        return t.compareTo(Common._min(bound1, bound2)) > 0 && t.compareTo(Common._max(bound1, bound2)) < 0;
    }

    public static <T extends Comparable<T>> T max(T c1, T c2, T ... others) {
        Common.checkNull(c1, "c1 is null");
        Common.checkNull(c2, "c2 is null");
        T currentMax = Common._max(c1, c2);
        if (others != null && others.length > 0) {
            int len = others.length;
            for (int i = 0; i < len; ++i) {
                Common.checkNull(others[i], "c" + (i + 3) + " is null");
                currentMax = Common._max(currentMax, others[i]);
            }
        }
        return currentMax;
    }

    private static <T extends Comparable<T>> T _min(T c1, T c2) {
        return c1.compareTo(c2) <= 0 ? c1 : c2;
    }

    public static String byte2hex(byte[] b) {
        return Common.byte2hex(b, 0, b.length);
    }

    public static String byte2hex(byte[] b, int offset, int length) {
        return Common.byte2hex(b, offset, length, 0, null);
    }

    public static String byte2hex(byte[] b, int col, String split) {
        return Common.byte2hex(b, 0, b.length, col, split);
    }

    public static String byte2hex(byte[] b, int offset, int length, int col, String split) {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        int n = offset;
        int l = Math.min(offset + length, b.length);
        while (n < l) {
            int tmp;
            if (col > 0 && index > 0 && index % col == 0) {
                builder.append(LINE_SEPARATOR);
            }
            if ((tmp = b[n] & 0xFF) < 16) {
                builder.append('0').append(Integer.toHexString(tmp));
            } else {
                builder.append(Integer.toHexString(tmp));
            }
            if (split != null) {
                builder.append(split);
            }
            ++n;
            ++index;
        }
        return builder.toString();
    }

    private static int hexCharValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    public static byte[] hex2byte(String hexString) {
        return Common.hex2byte(hexString, LINE_SEPARATOR + " ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] hex2byte(String hexString, String ignoreChars) {
        char[] ignore = ignoreChars == null ? new char[]{} : ignoreChars.toCharArray();
        int hi = -1;
        int low = -1;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean closed = true;
        for (char c : hexString.toCharArray()) {
            int charValue = Common.hexCharValue(c);
            if (charValue == -1) {
                if (!Common.inArray(c, ignore)) throw new RuntimeException("unknown hex char: " + c + "[0x" + Integer.toHexString(c) + "]");
                closed = true;
            } else {
                hi = low;
                low = charValue;
                boolean bl = closed = hi != -1 && low != -1;
            }
            if (!closed || low == -1) continue;
            byteArrayOutputStream.write(hi == -1 ? low : hi << 4 | low);
            hi = -1;
            low = -1;
        }
        if (low == -1) return byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.write(hi == -1 ? low : hi << 4 | low);
        return byteArrayOutputStream.toByteArray();
    }

    public static <T> Set<T> intersection(Set<T> set1, Set<T> set2) {
        HashSet<T> result = new HashSet<T>(set1);
        result.retainAll(set2);
        return result;
    }

    public static <T> Set<T> difference(Set<T> org, Set<T> todiv) {
        HashSet<T> result = new HashSet<T>(org);
        result.removeAll(todiv);
        return result;
    }

    private static <T, C extends Collection<T>> C join(C instance, Collection ... collections) {
        if (collections != null && collections.length > 0) {
            for (Collection c : collections) {
                if (c == null) continue;
                instance.addAll(c);
            }
        }
        return instance;
    }

    public static <T> Set<T> join(Collection<T> ... sets) {
        return Common.join(new HashSet(), (Collection[])sets);
    }

    public static String native2AscII(String str) {
        if (str == null) {
            return null;
        }
        char[] charPoints = str.toCharArray();
        StringBuffer strBuf = new StringBuffer();
        for (char ch : charPoints) {
            if (ch < '\u0100') {
                strBuf.append(ch);
                continue;
            }
            strBuf.append("\\u").append(Integer.toHexString(ch));
        }
        return strBuf.toString();
    }

    public static File getNewFile(String fileName) throws IOException {
        File f = new File(fileName);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        if (f.exists()) {
            f.delete();
        }
        f.createNewFile();
        return f;
    }

    public static URL getResource(String resource, ClassLoader ... classLoaders) {
        URL url;
        resource = Common.trim(resource, '/');
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (url = classLoader.getResource(resource)) != null) {
            return url;
        }
        if (classLoaders != null && classLoaders.length > 0) {
            for (ClassLoader cl : classLoaders) {
                url = cl.getResource(resource);
                if (url == null) continue;
                return url;
            }
        }
        if ((classLoader = Common.class.getClassLoader()) != null && (url = classLoader.getResource(resource)) != null) {
            return url;
        }
        return ClassLoader.getSystemResource(resource);
    }

    public static <T> int indexOf(T[] array, T t) {
        if (array == null) {
            throw new NullPointerException("indexOf: array must not be NULL.");
        }
        for (int i = 0; i < array.length; ++i) {
            if (!(t == null ? array[i] == null : t.equals(array[i]))) continue;
            return i;
        }
        return -1;
    }

    public static String concat(List<String> list, String split) {
        if (list == null) {
            return null;
        }
        switch (list.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return list.get(0);
            }
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                builder.append(split);
            }
            builder.append(list.get(i));
        }
        return builder.toString();
    }

    public static <T> T to(String str, T value) {
        if (value == null) {
            if (str == null) {
                return null;
            }
            throw new NullPointerException("value is null.");
        }
        Class<?> cls = value.getClass();
        if (cls.equals(String.class)) {
            return (T)(str == null ? value : str);
        }
        if (cls.isArray() && cls.getComponentType().equals(String.class)) {
            return (T)Common.toArray(str, ",", (String[])value);
        }
        StringConvertWithDefaultValue defaultValue = converterServiceLoader.select(cls);
        if (defaultValue == null) {
            throw new RuntimeException("String to " + cls + " is not supported.");
        }
        return (T)defaultValue.convertTo(str, value, cls);
    }

    public static int toInt(String str, Supplier<Integer> valueSupplier) {
        try {
            return Integer.parseInt(str);
        }
        catch (Throwable th) {
            return valueSupplier.get();
        }
    }

    public static int toInt(String str, int value) {
        try {
            return Integer.parseInt(str);
        }
        catch (Throwable th) {
            return value;
        }
    }

    public static long toLong(String str, Supplier<Long> value) {
        try {
            return Long.parseLong(str);
        }
        catch (Throwable th) {
            return value.get();
        }
    }

    public static long toLong(String str, long value) {
        try {
            return Long.parseLong(str);
        }
        catch (Throwable th) {
            return value;
        }
    }

    public static boolean toBool(String str, Supplier<Boolean> v) {
        String s = Common.nullToStr(str);
        if (s.equals("1") || s.equalsIgnoreCase("T") || s.equalsIgnoreCase("TRUE")) {
            return true;
        }
        if (s.equals("0") || s.equalsIgnoreCase("F") || s.equalsIgnoreCase("FALSE")) {
            return false;
        }
        return v.get();
    }

    public static boolean toBool(String str, boolean v) {
        String s = Common.nullToStr(str);
        if (s.equals("1") || s.equalsIgnoreCase("T") || s.equalsIgnoreCase("TRUE")) {
            return true;
        }
        if (s.equals("0") || s.equalsIgnoreCase("F") || s.equalsIgnoreCase("FALSE")) {
            return false;
        }
        return v;
    }

    public static List<String> toArray(String str, String delim, List<String> v) {
        if (Common.isBlank(str)) {
            return v;
        }
        StringTokenizer st = new StringTokenizer(str, delim, false);
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreElements()) {
            list.add(st.nextToken().trim());
        }
        return list;
    }

    public static String[] toArray(String str, String delim, Supplier<String[]> v) {
        List<String> list = Common.toArray(str, delim, (List<String>)null);
        return list == null ? v.get() : list.toArray(new String[0]);
    }

    public static String[] toArray(String str, String delim, String[] v) {
        List<String> list = Common.toArray(str, delim, (List<String>)null);
        return list == null ? v : list.toArray(new String[0]);
    }

    private static boolean inArray(char ch, char[] chars) {
        for (char c : chars) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    public static String trim(String str, char ... trimChars) {
        int start;
        if (Common.isBlank(str) || trimChars == null || trimChars.length == 0) {
            return str;
        }
        char[] chars = str.toCharArray();
        int end = chars.length;
        for (start = 0; start < end && Common.inArray(chars[start], trimChars); ++start) {
        }
        while (end > start && Common.inArray(chars[end - 1], trimChars)) {
            --end;
        }
        return new String(chars, start, end - start);
    }

    public static String trim(String str, String toTrim) {
        if (Common.isBlank(str) || Common.isBlank(toTrim)) {
            return str;
        }
        return Common.trim(str, toTrim.toCharArray());
    }

    public static boolean sameString(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    public static char randomGB2312Char() {
        try {
            int b1 = Common.random(176, 215);
            int b2 = Common.random(161, b1 == 215 ? 249 : 254);
            return new String(new byte[]{(byte)b1, (byte)b2}, "GB2312").charAt(0);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public static char randomChar(String s) {
        if (Common.isBlank(s)) {
            throw new IllegalArgumentException("range is blank.");
        }
        return s.charAt(Common.random(s.length()));
    }

    public static <T> T random(T[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length)];
    }

    public static byte random(byte[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length)];
    }

    public static short random(short[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length)];
    }

    public static int random(int[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length)];
    }

    public static long random(long[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length)];
    }

    public static float random(float[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length)];
    }

    public static double random(double[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length)];
    }

    public static String randomStr(int min, int max, String range) {
        StringBuilder builder = new StringBuilder();
        int j = Common.random(min, max);
        for (int i = 0; i < j; ++i) {
            builder.append(Common.randomChar(range));
        }
        return builder.toString();
    }

    public static boolean isSameStr(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static Calendar copy(Calendar calendar) {
        return calendar == null ? null : (Calendar)calendar.clone();
    }

    public static String lowerFirstChar(String string) {
        if (string == null) {
            return string;
        }
        char[] charSeq = string.toCharArray();
        if (charSeq.length > 0 && charSeq[0] >= 'A' && charSeq[0] <= 'Z') {
            charSeq[0] = (char)(charSeq[0] + 32);
            return new String(charSeq);
        }
        return string;
    }

    public static String upperFirstChar(String string) {
        if (string == null) {
            return string;
        }
        char[] charSeq = string.toCharArray();
        if (charSeq.length > 0 && charSeq[0] >= 'a' && charSeq[0] <= 'z') {
            charSeq[0] = (char)(charSeq[0] - 32);
            return new String(charSeq);
        }
        return string;
    }

    public static String camelCase(String s) {
        return Common.camelCase(s, false);
    }

    public static String camelCase(String s, String delimiters) {
        return Common.camelCase(s, false, delimiters);
    }

    public static String camelCase(String s, boolean firstCharUpperCase) {
        return Common.camelCase(s, firstCharUpperCase, DEFAULT_DELIM);
    }

    public static String camelCase(String s, boolean firstCharUpperCase, String delimiters) {
        StringTokenizer st = new StringTokenizer(s, delimiters);
        StringBuilder builder = new StringBuilder();
        while (st.hasMoreElements()) {
            String node = st.nextToken();
            if (node.length() == 0) continue;
            builder.append(Common.upperFirstChar(node));
        }
        return firstCharUpperCase ? Common.upperFirstChar(builder.toString()) : Common.lowerFirstChar(builder.toString());
    }

    private static int calculateStringDistance(String strA, String strB) {
        int i;
        int lenA = strA.length();
        int lenB = strB.length();
        int[][] c = new int[lenA + 1][lenB + 1];
        for (i = 0; i < lenA; ++i) {
            c[i][lenB] = lenA - i;
        }
        for (int j = 0; j < lenB; ++j) {
            c[lenA][j] = lenB - j;
        }
        c[lenA][lenB] = 0;
        for (i = lenA - 1; i >= 0; --i) {
            for (int j = lenB - 1; j >= 0; --j) {
                c[i][j] = strB.charAt(j) == strA.charAt(i) ? c[i + 1][j + 1] : Math.min(Math.min(c[i][j + 1], c[i + 1][j]), c[i + 1][j + 1]) + 1;
            }
        }
        return c[0][0];
    }

    public static double similarity(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return 0.0;
        }
        if (s1.equals(s2)) {
            return 1.0;
        }
        return 1.0f - (float)Common.calculateStringDistance(s1, s2) / ((float)Math.max(s1.length(), s2.length()) * 1.0f);
    }

    public static <T> Map<String, T> subMap(String prefix, Map<String, T> map) {
        HashMap<String, T> subMap = new HashMap<String, T>();
        String prefixKey = prefix.endsWith(".") ? prefix : prefix + '.';
        int length = prefixKey.length();
        for (String key : map.keySet()) {
            if (!key.startsWith(prefixKey) || key.length() <= length) continue;
            subMap.put(key.substring(length), map.get(prefixKey));
        }
        return subMap;
    }

    public static String calendarToStr(Calendar calendar, String format) {
        return Common.dateToStr(calendar.getTime(), format);
    }

    public static String calendarToStr(Calendar calendar) {
        return Common.calendarToStr(calendar, DEFAULT_DATETIME_FORMAT);
    }

    public static String dateToStr(Date date, String format) {
        return Common.getSafetyDateFormat(format).format(date);
    }

    public static String dateToStr(Date date) {
        return Common.dateToStr(date, DEFAULT_DATETIME_FORMAT);
    }

    public static DateFormat getSafetyDateFormat(String format) {
        if (threadLocal.get() == null) {
            threadLocal.set(new SingletonMap<String, DateFormat>(new SingletonMap.Builder<String, DateFormat>(){

                @Override
                public DateFormat build(String key) {
                    return new SimpleDateFormat(key);
                }
            }));
        }
        return threadLocal.get().get(format);
    }

    public static Date strToDate(String str, String format) throws ParseException {
        return Common.getSafetyDateFormat(format).parse(str);
    }

    public static Date strToDate(String str) throws ParseException {
        return Common.strToDate(str, DEFAULT_DATETIME_FORMAT);
    }

    public static Calendar strToCalendar(String str, String format) throws ParseException {
        return Common.dateToCalendar(Common.strToDate(str, format));
    }

    public static String longToDateStr(long l) {
        return Common.longToDateStr(l, DEFAULT_DATETIME_FORMAT);
    }

    public static String longToDateStr(long l, String format) {
        return Common.calendarToStr(Common.longToCalendar(l), format);
    }

    public static Calendar longToCalendar(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        return calendar;
    }

    public static Calendar dateToCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static <T extends Comparable<T>> T min(T c1, T c2, T ... others) {
        Common.checkNull(c1, "c1 is null");
        Common.checkNull(c2, "c2 is null");
        T currentMin = Common._min(c1, c2);
        if (others != null && others.length > 0) {
            int len = others.length;
            for (int i = 0; i < len; ++i) {
                Common.checkNull(others[i], "c" + (i + 3) + " is null");
                currentMin = Common._min(currentMin, others[i]);
            }
        }
        return currentMin;
    }

    public static Calendar calendar(int year) {
        return Common.buildCalendar(year, 0, 1, 0, 0, 0, 0);
    }

    public static Calendar calendar(int year, int month) {
        return Common.buildCalendar(year, month, 1, 0, 0, 0, 0);
    }

    public static Calendar calendar(int year, int month, int date) {
        return Common.buildCalendar(year, month, date, 0, 0, 0, 0);
    }

    public static Calendar calendar(int year, int month, int date, int hour) {
        return Common.buildCalendar(year, month, date, hour, 0, 0, 0);
    }

    public static Calendar calendar(int year, int month, int date, int hour, int minute) {
        return Common.buildCalendar(year, month, date, hour, minute, 0, 0);
    }

    public static Calendar calendar(int year, int month, int date, int hour, int minute, int second) {
        return Common.buildCalendar(year, month, date, hour, minute, second, 0);
    }

    public static Calendar calendar(int year, int month, int date, int hour, int minute, int second, int millisecond) {
        return Common.buildCalendar(year, month, date, hour, minute, second, millisecond);
    }

    private static Calendar buildCalendar(int year, int month, int date, int hour, int minute, int second, int millisecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, date);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisecond);
        return calendar;
    }

    public static Calendar truncate(Calendar calendar, int fromField) {
        Calendar result = (Calendar)calendar.clone();
        switch (fromField) {
            case 1: {
                result.set(1, 1970);
            }
            case 2: {
                result.set(2, 0);
            }
            case 5: {
                result.set(5, 1);
            }
            case 10: 
            case 11: {
                result.set(11, 0);
            }
            case 12: {
                result.set(12, 0);
            }
            case 13: {
                result.set(13, 0);
            }
            case 14: {
                result.set(14, 0);
            }
        }
        return result;
    }

    public static String now() {
        return Common.now(DEFAULT_DATETIME_FORMAT);
    }

    public static String now(String format) {
        return Common.dateToStr(Clock.now().getTime(), format);
    }

    public static RuntimeException runtimeException(Throwable th) {
        return th instanceof RuntimeException ? (RuntimeException)th : new RuntimeException(th.getLocalizedMessage(), th);
    }

    public static Long getSystemStart() {
        return ManagementFactory.getRuntimeMXBean().getStartTime();
    }

    private static boolean isMatch(Pattern p, String str) {
        return p.matcher(str).find();
    }

    private static class PathPattern {
        private Pattern pattern;
        private String path;
        private String originalPath;

        public PathPattern(String path) {
            this.originalPath = path;
            this.pattern = Pattern.compile("^" + Common.trim(path, new char[0]).replaceAll("\\.", "\\\\.").replaceAll("/\\*{2,}/", "(/|/.+/)").replaceAll("\\*{2,}", ".+").replaceAll("\\*", "[^/]+") + ".*");
            this.path = Common.pathRoot(path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PathPattern)) {
                return false;
            }
            PathPattern that = (PathPattern)o;
            return this.originalPath.equals(that.originalPath);
        }

        public int hashCode() {
            return this.originalPath.hashCode();
        }
    }

    public static class StringToBoolean
    implements StringConvertWithDefaultValue {
        @Override
        public Object convertTo(String str, Object defaultValue, Class<?> type) {
            return Common.toBool(str, (Boolean)defaultValue);
        }

        @Override
        public boolean accept(Class<?> param) {
            return Boolean.TYPE.equals(param) || Boolean.class.equals(param);
        }
    }

    public static class StringToLong
    implements StringConvertWithDefaultValue {
        @Override
        public Object convertTo(String str, Object defaultValue, Class<?> type) {
            return Common.toLong(str, (Long)defaultValue);
        }

        @Override
        public boolean accept(Class<?> param) {
            return Long.TYPE.equals(param) || Long.class.equals(param);
        }
    }

    public static class StringToInt
    implements StringConvertWithDefaultValue {
        @Override
        public Object convertTo(String str, Object defaultValue, Class<?> type) {
            return Common.toInt(str, (Integer)defaultValue);
        }

        @Override
        public boolean accept(Class<?> param) {
            return Integer.TYPE.equals(param) || Integer.class.equals(param);
        }
    }

    public static class StringToFloat
    implements StringConvertWithDefaultValue {
        @Override
        public Object convertTo(String str, Object defaultValue, Class<?> type) {
            try {
                return Float.valueOf(Float.parseFloat(str));
            }
            catch (Throwable t) {
                return defaultValue;
            }
        }

        @Override
        public boolean accept(Class<?> param) {
            return Float.TYPE.equals(param) || Float.class.equals(param);
        }
    }

    public static interface Processor {
        public void process(URL var1, String var2);
    }

    public static interface ResourceFilter {
        public boolean accept(String var1, String var2);
    }

    public static interface Function<T, R> {
        public R apply(T var1);
    }

    public static interface Supplier<T> {
        public T get();
    }
}

